/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.jms;

import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashMap;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.jms.StreamMessage;
import javax.jms.TextMessage;
import si.nevensrok.common.jms.MessageBodyExtractor;

public class DefaultMessageBodyExtractor
implements MessageBodyExtractor {
    @Override
    public Object getMessageBody(Message message) throws JMSException {
        if (message instanceof BytesMessage) {
            int len = (int)((BytesMessage)message).getBodyLength();
            byte[] buffer = new byte[len];
            ((BytesMessage)message).readBytes(buffer, len);
            return buffer;
        }
        if (message instanceof MapMessage) {
            HashMap<String, Object> data = new HashMap<String, Object>();
            Enumeration enumeration = ((MapMessage)message).getMapNames();
            while (enumeration.hasMoreElements()) {
                String name = (String)enumeration.nextElement();
                Object value = ((MapMessage)message).getObject(name);
                data.put(name, value);
            }
            return data;
        }
        if (message instanceof ObjectMessage) {
            return ((ObjectMessage)message).getObject();
        }
        if (message instanceof StreamMessage) {
            final StreamMessage streamMessage = (StreamMessage)message;
            return new InputStream(){

                @Override
                public int read() throws IOException {
                    try {
                        return streamMessage.readByte();
                    }
                    catch (JMSException e) {
                        throw new IOException("Error reading from JMS StreamMessage", e);
                    }
                }
            };
        }
        if (message instanceof TextMessage) {
            return ((TextMessage)message).getText();
        }
        return null;
    }
}

