/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.ehcache.tcp;

import java.util.ArrayList;
import java.util.List;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.distribution.CacheManagerPeerProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import si.nevensrok.common.ehcache.tcp.TcpCachePeer;
import si.nevensrok.common.network.tcp.TcpNetworkClient;
import si.nevensrok.common.network.tcp.TcpNetworkServer;

public class TcpCacheManagerPeerProvider
implements CacheManagerPeerProvider {
    private static final Logger log = LoggerFactory.getLogger(TcpCacheManagerPeerProvider.class);
    private CacheManager cacheManager;
    private TcpNetworkServer tcpNetworkServer;
    private List<TcpNetworkClient> tcpNetworkClients;
    private List<TcpCachePeer> cachePeers;

    public TcpCacheManagerPeerProvider(CacheManager cacheManager, TcpNetworkServer tcpNetworkServer, List<TcpNetworkClient> tcpNetworkClients) {
        this.cacheManager = cacheManager;
        this.tcpNetworkServer = tcpNetworkServer;
        this.tcpNetworkClients = tcpNetworkClients;
    }

    public void registerPeer(String nodeId) {
        log.trace("Registering peer: {}", (Object)nodeId);
    }

    public void unregisterPeer(String nodeId) {
        log.trace("Unregistering peer: {}", (Object)nodeId);
    }

    public List<TcpCachePeer> listRemoteCachePeers(Ehcache cache) throws CacheException {
        return this.cachePeers;
    }

    public void init() {
        try {
            this.tcpNetworkServer.afterPropertiesSet();
        }
        catch (Exception e) {
            log.error("Error initializing tcp server", (Throwable)e);
        }
        this.cachePeers = new ArrayList<TcpCachePeer>(this.tcpNetworkClients.size());
        for (TcpNetworkClient tcpNetworkClient : this.tcpNetworkClients) {
            try {
                tcpNetworkClient.afterPropertiesSet();
                this.cachePeers.add(new TcpCachePeer(this.cacheManager, tcpNetworkClient));
            }
            catch (Exception e) {
                log.error("Error creating cache peer", (Throwable)e);
            }
        }
    }

    public void dispose() throws CacheException {
        try {
            this.tcpNetworkServer.destroy();
        }
        catch (Exception e) {
            log.error("Error closing server", (Throwable)e);
        }
        if (this.cachePeers != null) {
            for (TcpCachePeer tcpCachePeer : this.cachePeers) {
                tcpCachePeer.close();
            }
        }
        if (this.tcpNetworkClients != null) {
            for (TcpNetworkClient tcpNetworkClient : this.tcpNetworkClients) {
                try {
                    tcpNetworkClient.destroy();
                }
                catch (Exception e) {
                    log.debug("Error while closing tcp client", (Throwable)e);
                }
            }
        }
    }

    public long getTimeForClusterToForm() {
        return 500L;
    }

    public String getScheme() {
        return "TCP";
    }
}

