/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.smssender;

import java.util.LinkedList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import si.nevensrok.common.smssender.SmsMessage;
import si.nevensrok.common.smssender.SmsMessageResponse;
import si.nevensrok.common.smssender.SmsSender;

public abstract class BackgroundSmsSender
implements SmsSender,
InitializingBean,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(BackgroundSmsSender.class);
    private boolean backgroundSenderActive = true;
    private Object smsSenderMonitor = new Object();
    private LinkedList<SmsMessage> smsList = new LinkedList();

    public void afterPropertiesSet() throws Exception {
        Thread thread = new Thread("Background sms message sender"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (log.isInfoEnabled()) {
                    log.info("Starting background sms message sender thread");
                }
                while (BackgroundSmsSender.this.backgroundSenderActive) {
                    SmsMessage smsMessage = null;
                    Object object = BackgroundSmsSender.this.smsSenderMonitor;
                    synchronized (object) {
                        while (BackgroundSmsSender.this.smsList.isEmpty() && BackgroundSmsSender.this.backgroundSenderActive) {
                            try {
                                BackgroundSmsSender.this.smsSenderMonitor.wait();
                            }
                            catch (Exception exception) {}
                        }
                        if (!BackgroundSmsSender.this.smsList.isEmpty()) {
                            smsMessage = (SmsMessage)BackgroundSmsSender.this.smsList.removeFirst();
                        }
                    }
                    if (smsMessage == null) continue;
                    try {
                        if (log.isTraceEnabled()) {
                            log.trace("Sending sms message: {}", (Object)smsMessage);
                        }
                        SmsMessageResponse smsMessageResponse = BackgroundSmsSender.this.sendSmsMessage(smsMessage);
                        if (!log.isTraceEnabled()) continue;
                        log.trace("Send sms message response: {}", (Object)smsMessageResponse);
                    }
                    catch (Exception e) {
                        log.error("Error while sending sms message", (Throwable)e);
                    }
                }
                if (log.isInfoEnabled()) {
                    log.info("Stopping background sms message sender thread");
                }
            }
        };
        thread.setDaemon(true);
        thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() throws Exception {
        this.backgroundSenderActive = false;
        Object object = this.smsSenderMonitor;
        synchronized (object) {
            this.smsList.clear();
            this.smsSenderMonitor.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendSmsMessageInBackground(SmsMessage smsMessage) {
        if (this.backgroundSenderActive) {
            Object object = this.smsSenderMonitor;
            synchronized (object) {
                this.smsList.add(smsMessage);
                this.smsSenderMonitor.notifyAll();
            }
        }
    }
}

