/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.hazelcast;

import com.hazelcast.core.HazelcastInstance;
import java.util.LinkedHashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import si.nevensrok.common.hazelcast.HazelcastDiscoveryPackage;
import si.nevensrok.common.hazelcast.HazelcastReplyPackage;
import si.nevensrok.common.network.NetworkMessage;
import si.nevensrok.common.network.udp.UdpMessageReceiver;
import si.nevensrok.common.network.udp.UdpMessageSender;

public class HazelcastBroadcastReplier {
    private static final Logger log = LoggerFactory.getLogger(HazelcastBroadcastReplier.class);
    private UdpMessageReceiver udpMessageReceiver = null;

    public HazelcastBroadcastReplier(final List<HazelcastInstance> hazelcastInstances, final String broadcastDomain, int broadcastPort, int broadcastPortCount) {
        for (int i = 0; i < broadcastPortCount; ++i) {
            final int port = broadcastPort + i;
            try {
                this.udpMessageReceiver = new UdpMessageReceiver();
                this.udpMessageReceiver.setPort(port);
                this.udpMessageReceiver.afterPropertiesSet();
                Thread thread = new Thread("Hazelcast broadcast replier for port " + port){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        log.debug("Hazelcast broadcast replier started on port {}", (Object)port);
                        while (HazelcastBroadcastReplier.this.udpMessageReceiver != null) {
                            try {
                                NetworkMessage networkMessage = HazelcastBroadcastReplier.this.udpMessageReceiver.receiveMessage();
                                HazelcastDiscoveryPackage hazelcastDiscoveryPackage = (HazelcastDiscoveryPackage)networkMessage.getData();
                                log.trace("Received package: {}", (Object)hazelcastDiscoveryPackage);
                                if (!broadcastDomain.equals(hazelcastDiscoveryPackage.getBroadcastDomain())) continue;
                                UdpMessageSender udpMessageSender = new UdpMessageSender();
                                udpMessageSender.setAddress(networkMessage.getSender().getHostAddress());
                                udpMessageSender.setPort(hazelcastDiscoveryPackage.getReplyToPort());
                                udpMessageSender.afterPropertiesSet();
                                LinkedHashMap<String, Integer> ports = new LinkedHashMap<String, Integer>();
                                List list = hazelcastInstances;
                                synchronized (list) {
                                    for (HazelcastInstance hazelcastInstance : hazelcastInstances) {
                                        String uuid = hazelcastInstance.getCluster().getLocalMember().getUuid();
                                        Integer port2 = hazelcastInstance.getCluster().getLocalMember().getAddress().getPort();
                                        ports.put(uuid, port2);
                                    }
                                }
                                udpMessageSender.sendMessage(new HazelcastReplyPackage(ports));
                                udpMessageSender.destroy();
                            }
                            catch (Exception e) {
                                log.trace("Error processing message", (Throwable)e);
                            }
                        }
                        log.debug("Hazelcast broadcast replier on port {} stopped", (Object)port);
                    }
                };
                thread.setDaemon(true);
                thread.start();
                break;
            }
            catch (Exception e) {
                log.trace("Error starting udp listener on port " + port, (Throwable)e);
                try {
                    this.udpMessageReceiver.destroy();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.udpMessageReceiver = null;
                continue;
            }
        }
    }

    public void close() {
        try {
            if (this.udpMessageReceiver != null) {
                this.udpMessageReceiver.destroy();
                this.udpMessageReceiver = null;
            }
        }
        catch (Exception e) {
            log.trace("Error closing udp message receiver", (Throwable)e);
        }
    }
}

