/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.remoting.jms;

import org.aopalliance.intercept.Interceptor;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.jms.remoting.JmsInvokerProxyFactoryBean;
import org.springframework.util.ClassUtils;
import si.nevensrok.common.remoting.jms.ServiceData;
import si.nevensrok.common.remoting.jms.ServiceRepository;

public class JmsServiceProxyFactoryBean
implements FactoryBean<Object>,
MethodInterceptor,
InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(JmsServiceProxyFactoryBean.class);
    private ServiceRepository serviceRepository;
    private Class<?> serviceInterface;
    private String version;
    private long receiveTimeout = 0L;
    private long lookupSleepTime = 10000L;
    private Object serviceProxy;
    private ClassLoader beanClassLoader = ClassUtils.getDefaultClassLoader();
    private JmsInvokerProxyFactoryBean jmsInvokerProxyFactoryBean;
    private Object jmsInvokerProxyFactoryBeanMonitor = new Object();

    public void setServiceRepository(ServiceRepository serviceRepository) {
        this.serviceRepository = serviceRepository;
    }

    public void setServiceInterface(Class<?> serviceInterface) {
        this.serviceInterface = serviceInterface;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setReceiveTimeout(long receiveTimeout) {
        this.receiveTimeout = receiveTimeout;
    }

    public void setLookupSleepTime(long lookupSleepTime) {
        this.lookupSleepTime = lookupSleepTime;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.serviceRepository == null) {
            throw new IllegalArgumentException("Property 'serviceRepository' is required");
        }
        if (this.serviceInterface == null) {
            throw new IllegalArgumentException("Property 'serviceInterface' is required");
        }
        if (this.version == null) {
            throw new IllegalArgumentException("Property 'version' is required");
        }
        this.serviceProxy = new ProxyFactory(this.serviceInterface, (Interceptor)this).getProxy(this.beanClassLoader);
        Thread thread = new Thread("Jms service lookup thread"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                while (true) {
                    try {
                        log.trace("Looking up for jms service [{}] with version [{}]", (Object)JmsServiceProxyFactoryBean.this.serviceInterface.getName(), (Object)JmsServiceProxyFactoryBean.this.version);
                        ServiceData serviceData = JmsServiceProxyFactoryBean.this.serviceRepository.findService(JmsServiceProxyFactoryBean.this.serviceInterface.getName(), JmsServiceProxyFactoryBean.this.version);
                        if (serviceData != null) {
                            Object object = JmsServiceProxyFactoryBean.this.jmsInvokerProxyFactoryBeanMonitor;
                            synchronized (object) {
                                JmsServiceProxyFactoryBean.this.jmsInvokerProxyFactoryBean = new JmsInvokerProxyFactoryBean();
                                JmsServiceProxyFactoryBean.this.jmsInvokerProxyFactoryBean.setServiceInterface(JmsServiceProxyFactoryBean.this.serviceInterface);
                                JmsServiceProxyFactoryBean.this.jmsInvokerProxyFactoryBean.setConnectionFactory(JmsServiceProxyFactoryBean.this.serviceRepository.getConnectionFactory());
                                JmsServiceProxyFactoryBean.this.jmsInvokerProxyFactoryBean.setQueueName(serviceData.getQueue());
                                JmsServiceProxyFactoryBean.this.jmsInvokerProxyFactoryBean.setReceiveTimeout(JmsServiceProxyFactoryBean.this.receiveTimeout);
                                JmsServiceProxyFactoryBean.this.jmsInvokerProxyFactoryBean.afterPropertiesSet();
                                JmsServiceProxyFactoryBean.this.jmsInvokerProxyFactoryBeanMonitor.notifyAll();
                                break;
                            }
                        }
                        log.error("Service data is null");
                    }
                    catch (Exception e) {
                        log.error("Error looking up for jms service", (Throwable)e);
                    }
                    try {
                        Thread.sleep(JmsServiceProxyFactoryBean.this.lookupSleepTime);
                    }
                    catch (Exception exception) {}
                }
            }
        };
        thread.setDaemon(true);
        thread.start();
    }

    public Object getObject() throws Exception {
        return this.serviceProxy;
    }

    public Class<?> getObjectType() {
        return this.serviceInterface;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(MethodInvocation methodInvocation) throws Throwable {
        Object object = this.jmsInvokerProxyFactoryBeanMonitor;
        synchronized (object) {
            while (this.jmsInvokerProxyFactoryBean == null) {
                this.jmsInvokerProxyFactoryBeanMonitor.wait();
            }
        }
        return this.jmsInvokerProxyFactoryBean.invoke(methodInvocation);
    }

    public boolean isSingleton() {
        return true;
    }
}

