/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.x509cert;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import si.nevensrok.common.utils.ByteUtil;

public class KeyUtil {
    public static PrivateKey loadPrivateKey(InputStream inputStream) {
        try {
            byte[] data = KeyUtil.readData(inputStream);
            data = KeyUtil.transformFromBase64(data);
            PrivateKey privateKey = KeyUtil.loadPrivateKey(data, "RSA");
            if (privateKey == null) {
                privateKey = KeyUtil.loadPrivateKey(data, "DSA");
            }
            if (privateKey == null) {
                throw new RuntimeException("Error reading private key");
            }
            return privateKey;
        }
        catch (Exception e) {
            throw new RuntimeException("Error loading private key", e);
        }
    }

    public static PublicKey loadPublicKey(InputStream inputStream) {
        try {
            byte[] data = KeyUtil.readData(inputStream);
            data = KeyUtil.transformFromBase64(data);
            PublicKey publicKey = KeyUtil.loadPublicKey(data, "RSA");
            if (publicKey == null) {
                publicKey = KeyUtil.loadPublicKey(data, "DSA");
            }
            if (publicKey == null) {
                throw new RuntimeException("Error reading public key");
            }
            return publicKey;
        }
        catch (Exception e) {
            throw new RuntimeException("Error loading public key", e);
        }
    }

    private static byte[] readData(InputStream inputStream) throws IOException {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        int n = inputStream.read();
        while (n >= 0) {
            buffer.write(n);
            n = inputStream.read();
        }
        return buffer.toByteArray();
    }

    private static byte[] transformFromBase64(byte[] data) throws IOException {
        StringBuilder buffer = new StringBuilder();
        BufferedReader reader = new BufferedReader(new StringReader(new String(data, "ASCII")));
        boolean readKey = false;
        String line = reader.readLine();
        while (line != null) {
            line = line.trim();
            if (!readKey && line.startsWith("--") && line.indexOf("BEGIN") >= 0 && line.indexOf("KEY") >= 0) {
                readKey = true;
            } else {
                if (readKey && line.startsWith("--")) {
                    readKey = false;
                    break;
                }
                if (readKey) {
                    buffer.append(line);
                }
            }
            line = reader.readLine();
        }
        return ByteUtil.fromBase64String(buffer.toString());
    }

    private static PrivateKey loadPrivateKey(byte[] data, String type) throws NoSuchAlgorithmException {
        PrivateKey privateKey = null;
        try {
            KeyFactory keyFactory = KeyFactory.getInstance(type);
            PKCS8EncodedKeySpec privSpec = new PKCS8EncodedKeySpec(data);
            privateKey = keyFactory.generatePrivate(privSpec);
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            // empty catch block
        }
        return privateKey;
    }

    private static PublicKey loadPublicKey(byte[] data, String type) throws NoSuchAlgorithmException {
        PublicKey publicKey = null;
        try {
            KeyFactory keyFactory = KeyFactory.getInstance(type);
            X509EncodedKeySpec pubSpec = new X509EncodedKeySpec(data);
            publicKey = keyFactory.generatePublic(pubSpec);
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            // empty catch block
        }
        return publicKey;
    }
}

