/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

public class ObjectUtil {
    public static byte[] serializeObject(Object object) {
        if (!(object instanceof Serializable)) {
            throw new RuntimeException("Object is not serializable");
        }
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ObjectOutputStream outputStream = new ObjectOutputStream(buffer);
            outputStream.writeObject(object);
            outputStream.close();
            return buffer.toByteArray();
        }
        catch (Exception e) {
            throw new RuntimeException("Error serializing object", e);
        }
    }

    public static Object deserializeObject(byte[] data) {
        try {
            ByteArrayInputStream buffer = new ByteArrayInputStream(data);
            ObjectInputStream inputStream = new ObjectInputStream(buffer);
            Object object = inputStream.readObject();
            inputStream.close();
            return object;
        }
        catch (Exception e) {
            throw new RuntimeException("Error deserializing object", e);
        }
    }

    public static Object copyObject(Serializable object) {
        byte[] data = ObjectUtil.serializeObject(object);
        return ObjectUtil.deserializeObject(data);
    }

    public static void copyProperties(Object from, Object to) {
        HashMap<String, Object> fromFields = new HashMap<String, Object>();
        HashMap<String, Object> toFields = new HashMap<String, Object>();
        Class<?> clasz = from.getClass();
        while (!clasz.equals(Object.class)) {
            for (Field field : clasz.getDeclaredFields()) {
                fromFields.put(field.getName(), field);
            }
            clasz = clasz.getSuperclass();
        }
        clasz = to.getClass();
        while (!clasz.equals(Object.class)) {
            for (Field field : clasz.getDeclaredFields()) {
                toFields.put(field.getName(), field);
            }
            clasz = clasz.getSuperclass();
        }
        for (Map.Entry entry : fromFields.entrySet()) {
            Field fromField = (Field)entry.getValue();
            Field field = (Field)toFields.get(entry.getKey());
            if (field == null || !field.getType().isAssignableFrom(fromField.getType())) continue;
            Object value = ObjectUtil.getValue(fromField, from);
            ObjectUtil.setValue(field, to, value);
        }
    }

    public static void copyNotNullProperties(Object from, Object to) {
        HashMap<String, Object> fromFields = new HashMap<String, Object>();
        HashMap<String, Object> toFields = new HashMap<String, Object>();
        Class<?> clasz = from.getClass();
        while (!clasz.equals(Object.class)) {
            for (Field field : clasz.getDeclaredFields()) {
                fromFields.put(field.getName(), field);
            }
            clasz = clasz.getSuperclass();
        }
        clasz = to.getClass();
        while (!clasz.equals(Object.class)) {
            for (Field field : clasz.getDeclaredFields()) {
                toFields.put(field.getName(), field);
            }
            clasz = clasz.getSuperclass();
        }
        for (Map.Entry entry : fromFields.entrySet()) {
            Object value;
            Field fromField = (Field)entry.getValue();
            Field field = (Field)toFields.get(entry.getKey());
            if (field == null || !field.getType().isAssignableFrom(fromField.getType()) || (value = ObjectUtil.getValue(fromField, from)) == null) continue;
            ObjectUtil.setValue(field, to, value);
        }
    }

    public static Object getValue(Field field, Object object) {
        Object value = null;
        try {
            Method getterMethod = ObjectUtil.findGetterMethod(field);
            if (getterMethod != null) {
                value = getterMethod.invoke(object, new Object[0]);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error getting value", e);
        }
        return value;
    }

    public static void setValue(Field field, Object object, Object value) {
        try {
            Method setterMethod = ObjectUtil.findSetterMethod(field);
            if (setterMethod != null) {
                setterMethod.invoke(object, value);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error setting value", e);
        }
    }

    public static Method findGetterMethod(Field field) {
        String methodName = "get" + field.getName();
        for (Method method : field.getDeclaringClass().getMethods()) {
            if (method.getParameterTypes().length != 0 || !method.getName().equalsIgnoreCase(methodName) || !method.getReturnType().isAssignableFrom(field.getType())) continue;
            return method;
        }
        return null;
    }

    public static Method findSetterMethod(Field field) {
        String methodName = "set" + field.getName();
        for (Method method : field.getDeclaringClass().getMethods()) {
            Class<?>[] parameters = method.getParameterTypes();
            if (parameters.length != 1 || !parameters[0].isAssignableFrom(field.getType()) || !method.getName().equalsIgnoreCase(methodName)) continue;
            return method;
        }
        return null;
    }

    public static Field getFieldByName(Object object, String fieldName) {
        Class<?> classToCheck = object.getClass();
        while (!classToCheck.equals(Object.class)) {
            for (Field field : classToCheck.getDeclaredFields()) {
                if (!field.getName().equals(fieldName)) continue;
                return field;
            }
            classToCheck = classToCheck.getSuperclass();
        }
        return null;
    }

    public static void trimStringProperties(Object obj) {
        Class<?> clasz = obj.getClass();
        while (!clasz.equals(Object.class)) {
            for (Field field : clasz.getDeclaredFields()) {
                String text;
                if (!field.getType().equals(String.class) || (text = (String)ObjectUtil.getValue(field, obj)) == null) continue;
                ObjectUtil.setValue(field, obj, text.trim());
            }
            clasz = clasz.getSuperclass();
        }
    }
}

