/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.ssl;

import java.security.KeyStore;
import java.security.SecureRandom;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import si.nevensrok.common.ssl.KeystoreKeyManager;
import si.nevensrok.common.ssl.KeystoreTrustManager;
import si.nevensrok.common.ssl.SslContextGenerator;

public class KeystoreSslContextGenerator
implements SslContextGenerator,
InitializingBean,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(KeystoreSslContextGenerator.class);
    private String protocol = "TLS";
    private SSLContext sslContext;
    private KeystoreTrustManager trustManager;
    private KeystoreKeyManager keyManager;
    private SSLContext oldSslContext = null;
    private boolean overrideDefault = false;
    private boolean trustAll = false;
    private boolean checkDate = true;
    private KeyStore keyStore;
    private String keyStorePassword;
    private KeyStore trustStore;

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public void setOverrideDefault(boolean overrideDefault) {
        this.overrideDefault = overrideDefault;
    }

    public void setTrustAll(boolean trustAll) {
        this.trustAll = trustAll;
    }

    public void setCheckDate(boolean checkDate) {
        this.checkDate = checkDate;
    }

    public void setKeyStore(KeyStore keyStore) {
        this.keyStore = keyStore;
    }

    public void setKeyStorePassword(String keyStorePassword) {
        this.keyStorePassword = keyStorePassword;
    }

    public void setTrustStore(KeyStore trustStore) {
        this.trustStore = trustStore;
    }

    public void afterPropertiesSet() throws Exception {
        try {
            this.sslContext = SSLContext.getInstance(this.protocol);
            if (this.keyStore != null && this.keyStorePassword != null) {
                this.keyManager = new KeystoreKeyManager(this.keyStore, this.keyStorePassword);
            }
            this.trustManager = this.trustAll ? new KeystoreTrustManager(true) : (this.trustStore == null ? new KeystoreTrustManager() : new KeystoreTrustManager(this.trustStore, this.checkDate));
            KeyManager[] keyManagerList = new KeyManager[]{this.keyManager};
            TrustManager[] trustManagerList = new TrustManager[]{this.trustManager};
            SecureRandom secureRandom = new SecureRandom();
            this.sslContext.init(keyManagerList, trustManagerList, secureRandom);
            if (this.overrideDefault) {
                this.oldSslContext = SSLContext.getDefault();
                log.info("Overriding default SSL context");
                SSLContext.setDefault(this.sslContext);
            }
        }
        catch (Exception e) {
            log.error("Error initializing SSL Context", (Throwable)e);
        }
    }

    public void destroy() throws Exception {
        if (this.overrideDefault && this.oldSslContext != null) {
            log.info("Reverting default SSL context");
            SSLContext.setDefault(this.oldSslContext);
        }
    }

    @Override
    public SSLContext generateSSLContext() {
        return this.sslContext;
    }

    public X509KeyManager getKeyManager() {
        return this.keyManager;
    }

    public X509TrustManager getTrustManager() {
        return this.trustManager;
    }
}

