/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.cache.hazelcast;

import com.hazelcast.core.HazelcastInstance;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import si.nevensrok.common.cache.AbstractCache;
import si.nevensrok.common.cache.CacheSettings;
import si.nevensrok.common.cache.CachedValue;

public class HazelcastCache
extends AbstractCache {
    private static final Logger log = LoggerFactory.getLogger(HazelcastCache.class);
    private Map<Object, CachedValue> cache;
    private List<Object> keyList;
    private Lock lock;

    public HazelcastCache(String name, CacheSettings cacheSettings, HazelcastInstance hazelcastInstance, String namePrefix) {
        super(name, cacheSettings);
        this.cache = hazelcastInstance.getMap(namePrefix + "map." + name);
        this.keyList = hazelcastInstance.getList(namePrefix + "keyList." + name);
        this.lock = hazelcastInstance.getLock(namePrefix + "lock." + name);
    }

    @Override
    public CachedValue get(Object key) {
        CachedValue cachedValue = this.cache.get(key);
        if (cachedValue != null && !this.isCacheValid(cachedValue)) {
            cachedValue = null;
        }
        return cachedValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(Object key, Object value) {
        this.lock.lock();
        try {
            this.cache.remove(key);
            this.keyList.remove(key);
            CachedValue cachedValue = new CachedValue(value, this.generateValidUntil());
            log.trace("Adding value to cache: {}", (Object)cachedValue);
            this.cache.put(key, cachedValue);
            this.keyList.add(0, key);
            if (this.getCacheSettings().getMaxElements() != null && this.cache.size() > this.getCacheSettings().getMaxElements()) {
                Object keyToRemove = this.keyList.remove(this.keyList.size() - 1);
                this.cache.remove(keyToRemove);
                log.trace("Removing key becuase of cache size: {}", keyToRemove);
            }
        }
        catch (Throwable e) {
            log.error("Error adding cache", e);
        }
        finally {
            this.lock.unlock();
        }
    }

    public void evict(Object key) {
        this.lock.lock();
        try {
            this.cache.remove(key);
            this.keyList.remove(key);
        }
        catch (Throwable e) {
            log.error("Error evicting cache", e);
        }
        finally {
            this.lock.unlock();
        }
    }

    public void clear() {
        this.lock.lock();
        try {
            this.cache.clear();
            this.keyList.clear();
        }
        catch (Throwable e) {
            log.error("Error clearing cache", e);
        }
        finally {
            this.lock.unlock();
        }
    }
}

