/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.logging.requestlog;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.annotation.Annotation;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import si.nevensrok.common.logging.requestlog.MethodLoggerConfig;
import si.nevensrok.common.logging.requestlog.ParameterLoggerConfig;
import si.nevensrok.common.logging.requestlog.Request;
import si.nevensrok.common.logging.requestlog.RequestParameter;

public class RequestLogger
implements InitializingBean,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(RequestLogger.class);
    private LinkedList<Connection> connections = null;
    private boolean internalExecutor = false;
    private Executor executor = null;
    private String dateFormatText = "yyyy/MM/dd HH:mm:ss.SSS Z";
    private String driver;
    private String url;
    private String username;
    private String password;
    private String machineName;
    private String sequenceName = "RequestIdSeq";
    private String requestsTable = "Requests";
    private String requestDatasTable = "RequestDatas";
    private String responseDatasTable = "ResponseDatas";
    private boolean logWithoutError = true;
    private boolean logWithError = true;
    private int minDurationToLog = Integer.MIN_VALUE;
    private boolean addDatePrefixToRequestId = false;
    private Set<Class<?>> excludeClasses = null;
    private Set<String> excludeNames = null;

    public void setExecutor(Executor executor) {
        this.executor = executor;
    }

    public void setDateFormat(String dateFormat) {
        this.dateFormatText = dateFormat;
    }

    public void setDriver(String driver) {
        this.driver = driver;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setMachineName(String machineName) {
        this.machineName = machineName;
    }

    public void setSequenceName(String sequenceName) {
        this.sequenceName = sequenceName;
    }

    public void setRequestsTable(String requestsTable) {
        this.requestsTable = requestsTable;
    }

    public void setRequestDatasTable(String requestDatasTable) {
        this.requestDatasTable = requestDatasTable;
    }

    public void setResponseDatasTable(String responseDatasTable) {
        this.responseDatasTable = responseDatasTable;
    }

    public void setLogWithError(boolean logWithError) {
        this.logWithError = logWithError;
    }

    public void setLogWithoutError(boolean logWithoutError) {
        this.logWithoutError = logWithoutError;
    }

    public void setMinDurationToLog(int minDurationToLog) {
        this.minDurationToLog = minDurationToLog;
    }

    public void setAddDatePrefixToRequestId(boolean addDatePrefixToRequestId) {
        this.addDatePrefixToRequestId = addDatePrefixToRequestId;
    }

    public void setExcludeClasses(Set<Class<?>> excludeClasses) {
        this.excludeClasses = excludeClasses;
    }

    public void setExcludeNames(Set<String> excludeNames) {
        this.excludeNames = excludeNames;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.executor == null) {
            this.internalExecutor = true;
            this.executor = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
        }
        this.connections = new LinkedList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() throws Exception {
        if (this.internalExecutor) {
            ((ThreadPoolExecutor)this.executor).shutdown();
        }
        if (this.connections != null) {
            LinkedList<Connection> linkedList = this.connections;
            synchronized (linkedList) {
                for (Connection connection : this.connections) {
                    try {
                        connection.close();
                    }
                    catch (Exception exception) {}
                }
                this.connections.clear();
                this.connections = null;
            }
        }
    }

    public Object logRequest(ProceedingJoinPoint point) throws Throwable {
        if (!this.isTrack(point)) {
            return point.proceed();
        }
        Object result = null;
        Throwable error = null;
        final Request request = new Request();
        request.setRequestDate(Calendar.getInstance().getTime());
        request.setMethodId(this.generateMethodId(point));
        request.setBeanName(this.getBeanName(point));
        request.setThreadName(Thread.currentThread().getName());
        request.setWithoutError(Boolean.TRUE);
        request.setRequestDatas(this.generateRequestDataList(point));
        long startTime = System.currentTimeMillis();
        try {
            result = point.proceed();
        }
        catch (Throwable e) {
            error = e;
            request.setErrorData(this.generateErrorText(e));
            request.setWithoutError(Boolean.FALSE);
        }
        long duration = System.currentTimeMillis() - startTime;
        request.setDuration((int)duration);
        if ((this.logWithoutError && request.getWithoutError().booleanValue() && this.isLogWithoutError(point) || this.logWithError && !request.getWithoutError().booleanValue() && this.isLogWithError(point)) && duration >= (long)this.minDurationToLog && duration >= (long)this.getMinDurationToLog(point)) {
            if (this.isLogMethodResponse(point)) {
                request.setResponseDatas(this.generateResponseDataList(result));
            } else {
                request.setResponseDatas(new LinkedList<RequestParameter>());
            }
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    RequestLogger.this.saveToDatabase(request);
                }
            });
        }
        if (error != null) {
            throw error;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveToDatabase(Request request) {
        Object networkInterface;
        if (this.connections == null) {
            return;
        }
        String machineIp4 = null;
        String machineIp6 = null;
        String machineHostname = null;
        String processName = ManagementFactory.getRuntimeMXBean().getName();
        try {
            machineHostname = InetAddress.getLocalHost().getHostName();
        }
        catch (Exception e) {
            log.error("Error retriving hostname", (Throwable)e);
        }
        try {
            Enumeration<NetworkInterface> networkInterfaceEnumerator = NetworkInterface.getNetworkInterfaces();
            while (networkInterfaceEnumerator.hasMoreElements()) {
                networkInterface = networkInterfaceEnumerator.nextElement();
                if (!((NetworkInterface)networkInterface).isUp() || ((NetworkInterface)networkInterface).isLoopback() || ((NetworkInterface)networkInterface).isVirtual()) continue;
                Enumeration<InetAddress> addressEnumerator = ((NetworkInterface)networkInterface).getInetAddresses();
                while (addressEnumerator.hasMoreElements()) {
                    InetAddress address = addressEnumerator.nextElement();
                    if (address instanceof Inet4Address) {
                        Inet4Address inet4Address = (Inet4Address)address;
                        machineIp4 = inet4Address.getHostAddress();
                        continue;
                    }
                    if (!(address instanceof Inet6Address)) continue;
                    Inet6Address inet6Address = (Inet6Address)address;
                    machineIp6 = inet6Address.getHostAddress();
                }
            }
        }
        catch (Exception e) {
            log.error("Error retriving machine ip addresses", (Throwable)e);
        }
        Connection connection = null;
        networkInterface = this.connections;
        synchronized (networkInterface) {
            if (!this.connections.isEmpty()) {
                connection = this.connections.removeFirst();
            }
        }
        if (connection == null) {
            connection = this.openConnection();
        }
        try {
            PreparedStatement preparedStatement;
            connection.setSavepoint();
            Long requestId = null;
            if (this.driver.equals("org.postgresql.Driver") || this.driver.equals("oracle.jdbc.driver.OracleDriver")) {
                requestId = this.getNextRequestId(connection, request.getRequestDate());
            }
            StringBuilder sql = new StringBuilder();
            sql.append("insert into ");
            sql.append(this.requestsTable);
            sql.append(" (");
            if (this.driver.equals("org.postgresql.Driver") || this.driver.equals("oracle.jdbc.driver.OracleDriver")) {
                sql.append("RequestId,");
            }
            sql.append("MethodId,BeanName,RequestDate,ThreadName,Duration,WithoutError,ErrorData,MachineIp4,MachineIp6,MachineHostname,MachineName,ProcessName) values (");
            if (this.driver.equals("org.postgresql.Driver") || this.driver.equals("oracle.jdbc.driver.OracleDriver")) {
                sql.append("?,");
            }
            sql.append("?,?,?,?,?,?,?,?,?,?,?,?)");
            int parameterCounter = 1;
            if (this.driver.equals("org.postgresql.Driver") || this.driver.equals("oracle.jdbc.driver.OracleDriver")) {
                preparedStatement = connection.prepareStatement(sql.toString());
                preparedStatement.setLong(parameterCounter++, requestId);
            } else {
                preparedStatement = connection.prepareStatement(sql.toString(), 1);
            }
            preparedStatement.setString(parameterCounter++, request.getMethodId());
            preparedStatement.setString(parameterCounter++, request.getBeanName());
            preparedStatement.setTimestamp(parameterCounter++, new Timestamp(request.getRequestDate().getTime()));
            preparedStatement.setString(parameterCounter++, request.getThreadName());
            preparedStatement.setInt(parameterCounter++, request.getDuration());
            preparedStatement.setBoolean(parameterCounter++, request.getWithoutError());
            preparedStatement.setString(parameterCounter++, request.getErrorData());
            preparedStatement.setString(parameterCounter++, machineIp4);
            preparedStatement.setString(parameterCounter++, machineIp6);
            preparedStatement.setString(parameterCounter++, machineHostname);
            preparedStatement.setString(parameterCounter++, this.machineName);
            preparedStatement.setString(parameterCounter++, processName);
            if (preparedStatement.executeUpdate() > 0 && (this.driver.equals("com.mysql.jdbc.Driver") || this.driver.equals("com.microsoft.sqlserver.jdbc.SQLServerDriver"))) {
                ResultSet resultSet = preparedStatement.getGeneratedKeys();
                if (resultSet.next()) {
                    requestId = resultSet.getLong(1);
                }
                resultSet.close();
            }
            preparedStatement.close();
            for (RequestParameter requestData : request.getRequestDatas()) {
                preparedStatement = connection.prepareStatement("insert into " + this.requestDatasTable + " (RequestId,ParameterName,ParameterValue,ParameterClass) values (?,?,?,?)");
                preparedStatement.setLong(1, requestId);
                preparedStatement.setString(2, requestData.getParameterName());
                preparedStatement.setString(3, requestData.getParameterValue());
                preparedStatement.setString(4, requestData.getParameterClass());
                preparedStatement.executeUpdate();
                preparedStatement.close();
            }
            for (RequestParameter responseData : request.getResponseDatas()) {
                preparedStatement = connection.prepareStatement("insert into " + this.responseDatasTable + " (RequestId,ParameterName,ParameterValue,ParameterClass) values (?,?,?,?)");
                preparedStatement.setLong(1, requestId);
                preparedStatement.setString(2, responseData.getParameterName());
                preparedStatement.setString(3, responseData.getParameterValue());
                preparedStatement.setString(4, responseData.getParameterClass());
                preparedStatement.executeUpdate();
                preparedStatement.close();
            }
            connection.commit();
        }
        catch (Exception e) {
            log.error("Error saving request to database", (Throwable)e);
            try {
                connection.rollback();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                connection.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            connection = null;
        }
        if (this.connections != null && connection != null) {
            LinkedList<Connection> linkedList = this.connections;
            synchronized (linkedList) {
                this.connections.addFirst(connection);
            }
        }
    }

    private Connection openConnection() {
        try {
            Class.forName(this.driver);
            Connection connection = DriverManager.getConnection(this.url, this.username, this.password);
            connection.setAutoCommit(false);
            return connection;
        }
        catch (Exception e) {
            log.error("Error oppening connection", (Throwable)e);
            return null;
        }
    }

    private Long getNextRequestId(Connection connection, Date date) throws SQLException {
        PreparedStatement preparedStatement;
        Long requestId = null;
        if (this.driver.equals("org.postgresql.Driver")) {
            preparedStatement = connection.prepareStatement("select nextval('" + this.sequenceName + "')");
            ResultSet resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                requestId = resultSet.getLong(1);
            }
            preparedStatement.close();
        } else if (this.driver.equals("oracle.jdbc.driver.OracleDriver")) {
            preparedStatement = connection.prepareStatement("select " + this.sequenceName + ".nextval from dual");
            ResultSet resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                requestId = resultSet.getLong(1);
            }
            preparedStatement.close();
        }
        if (requestId != null && this.addDatePrefixToRequestId) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            requestId = requestId + (long)calendar.get(1) * 100000000000000L;
            requestId = requestId + (long)(calendar.get(2) + 1) * 1000000000000L;
            requestId = requestId + (long)calendar.get(5) * 10000000000L;
        }
        return requestId;
    }

    private String generateMethodId(ProceedingJoinPoint point) {
        StringBuilder methodId = new StringBuilder();
        methodId.append(point.getTarget().getClass().getName());
        methodId.append("->");
        methodId.append(point.getSignature().getName());
        if (point.getSignature() instanceof MethodSignature) {
            MethodSignature methodSignature = (MethodSignature)point.getSignature();
            methodId.append("(");
            boolean firstParameter = true;
            for (Class clazz : methodSignature.getParameterTypes()) {
                if (firstParameter) {
                    firstParameter = false;
                } else {
                    methodId.append(",");
                }
                methodId.append(clazz.getName());
            }
            methodId.append(")");
        }
        return methodId.toString();
    }

    private String generateErrorText(Throwable e) {
        StringWriter buffer = new StringWriter();
        e.printStackTrace(new PrintWriter(buffer));
        return buffer.getBuffer().toString();
    }

    private List<RequestParameter> generateRequestDataList(ProceedingJoinPoint point) {
        LinkedList<RequestParameter> requestDatas = new LinkedList<RequestParameter>();
        if (point.getSignature() instanceof MethodSignature) {
            MethodSignature methodSignature = (MethodSignature)point.getSignature();
            String[] names = methodSignature.getParameterNames();
            Class[] classes = methodSignature.getParameterTypes();
            Annotation[][] annotations = methodSignature.getMethod().getParameterAnnotations();
            for (int i = 0; i < names.length; ++i) {
                if (!this.isLogParameter(annotations[i], classes[i], names[i])) continue;
                Object value = point.getArgs()[i];
                RequestParameter requestData = new RequestParameter();
                requestData.setParameterName(names[i]);
                if (value == null) {
                    requestData.setParameterClass(classes[i].getName());
                } else {
                    requestData.setParameterClass(value.getClass().getName());
                }
                requestData.setParameterValue(this.transformFieldValue(value));
                requestDatas.add(requestData);
                if (value == null || value.getClass().equals(Object.class)) continue;
                this.addParametersToRequestDataList(names[i], value, requestDatas, new LinkedList<Object>());
            }
        }
        return requestDatas;
    }

    private void addParametersToRequestDataList(String namePrefix, Object obj, List<RequestParameter> requestDatas, List<Object> processedObjects) {
        if (RequestLogger.contansObject(obj, processedObjects)) {
            return;
        }
        processedObjects.add(obj);
        if (obj instanceof Object[]) {
            Object[] list = (Object[])obj;
            for (int i = 0; i < list.length; ++i) {
                Object value = list[i];
                RequestParameter requestData = new RequestParameter();
                requestData.setParameterName(namePrefix + ">[" + i + "]");
                if (value != null) {
                    requestData.setParameterClass(value.getClass().getName());
                }
                requestData.setParameterValue(this.transformFieldValue(value));
                requestDatas.add(requestData);
                if (value == null || value.getClass().equals(Object.class)) continue;
                this.addParametersToRequestDataList(namePrefix + ">[" + i + "]", value, requestDatas, processedObjects);
            }
        } else if (obj instanceof Collection) {
            Collection list = (Collection)obj;
            int i = 0;
            for (Object value : list) {
                RequestParameter requestData = new RequestParameter();
                requestData.setParameterName(namePrefix + ">[" + i + "]");
                if (value != null) {
                    requestData.setParameterClass(value.getClass().getName());
                }
                requestData.setParameterValue(this.transformFieldValue(value));
                requestDatas.add(requestData);
                if (value != null && !value.getClass().equals(Object.class)) {
                    this.addParametersToRequestDataList(namePrefix + ">[" + i + "]", value, requestDatas, processedObjects);
                }
                ++i;
            }
        } else {
            for (Field field : obj.getClass().getDeclaredFields()) {
                if (!this.isLogParameter(field.getAnnotations(), field.getType(), field.getName())) continue;
                boolean addField = true;
                Object value = null;
                try {
                    if (field.isAccessible()) {
                        value = field.get(obj);
                    } else {
                        Method getterMethod = RequestLogger.findGetterMethod(field);
                        if (getterMethod != null) {
                            value = getterMethod.invoke(obj, new Object[0]);
                        } else {
                            addField = false;
                        }
                    }
                }
                catch (Exception e) {
                    log.error("Error fetching field value", (Throwable)e);
                    addField = false;
                }
                if (!addField) continue;
                RequestParameter requestData = new RequestParameter();
                requestData.setParameterName(namePrefix + ">" + field.getName());
                if (value == null) {
                    requestData.setParameterClass(field.getType().getName());
                } else {
                    requestData.setParameterClass(value.getClass().getName());
                }
                requestData.setParameterValue(this.transformFieldValue(value));
                requestDatas.add(requestData);
                if (value == null || value.getClass().equals(Object.class)) continue;
                this.addParametersToRequestDataList(namePrefix + ">" + field.getName(), value, requestDatas, processedObjects);
            }
        }
    }

    private List<RequestParameter> generateResponseDataList(Object obj) {
        LinkedList<RequestParameter> responseDatas = new LinkedList<RequestParameter>();
        RequestParameter responseData = new RequestParameter();
        responseData.setParameterName("return");
        if (obj != null) {
            responseData.setParameterClass(obj.getClass().getName());
            responseData.setParameterValue(this.transformFieldValue(obj));
        }
        responseDatas.add(responseData);
        if (obj != null && !obj.getClass().equals(Object.class)) {
            this.addParametersToResponseDataList("return", obj, responseDatas, new LinkedList<Object>());
        }
        return responseDatas;
    }

    private void addParametersToResponseDataList(String namePrefix, Object obj, List<RequestParameter> responseDatas, List<Object> processedObjects) {
        if (RequestLogger.contansObject(obj, processedObjects)) {
            return;
        }
        processedObjects.add(obj);
        if (obj instanceof Object[]) {
            Object[] list = (Object[])obj;
            for (int i = 0; i < list.length; ++i) {
                Object value = list[i];
                RequestParameter responseData = new RequestParameter();
                responseData.setParameterName(namePrefix + ">[" + i + "]");
                if (value != null) {
                    responseData.setParameterClass(value.getClass().getName());
                }
                responseData.setParameterValue(this.transformFieldValue(value));
                responseDatas.add(responseData);
                if (value == null || value.getClass().equals(Object.class)) continue;
                this.addParametersToResponseDataList(namePrefix + ">[" + i + "]", value, responseDatas, processedObjects);
            }
        } else if (obj instanceof Collection) {
            Collection list = (Collection)obj;
            int i = 0;
            for (Object value : list) {
                RequestParameter responseData = new RequestParameter();
                responseData.setParameterName(namePrefix + ">[" + i + "]");
                if (value != null) {
                    responseData.setParameterClass(value.getClass().getName());
                }
                responseData.setParameterValue(this.transformFieldValue(value));
                responseDatas.add(responseData);
                if (value != null && !value.getClass().equals(Object.class)) {
                    this.addParametersToResponseDataList(namePrefix + ">[" + i + "]", value, responseDatas, processedObjects);
                }
                ++i;
            }
        } else {
            for (Field field : obj.getClass().getDeclaredFields()) {
                if (!this.isLogParameter(field.getAnnotations(), field.getType(), field.getName())) continue;
                boolean addField = true;
                Object value = null;
                try {
                    if (field.isAccessible()) {
                        value = field.get(obj);
                    } else {
                        Method getterMethod = RequestLogger.findGetterMethod(field);
                        if (getterMethod != null) {
                            value = getterMethod.invoke(obj, new Object[0]);
                        } else {
                            addField = false;
                        }
                    }
                }
                catch (Exception e) {
                    log.error("Error fetching field value", (Throwable)e);
                    addField = false;
                }
                if (!addField) continue;
                RequestParameter responseData = new RequestParameter();
                responseData.setParameterName(namePrefix + ">" + field.getName());
                if (value == null) {
                    responseData.setParameterClass(field.getType().getName());
                } else {
                    responseData.setParameterClass(value.getClass().getName());
                }
                responseData.setParameterValue(this.transformFieldValue(value));
                responseDatas.add(responseData);
                if (value == null || value.getClass().equals(Object.class)) continue;
                this.addParametersToResponseDataList(namePrefix + ">" + field.getName(), value, responseDatas, processedObjects);
            }
        }
    }

    private String transformFieldValue(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Date) {
            return new SimpleDateFormat(this.dateFormatText).format((Date)value);
        }
        if (value instanceof Calendar) {
            return new SimpleDateFormat(this.dateFormatText).format(((Calendar)value).getTime());
        }
        return value.toString();
    }

    public static Method findGetterMethod(Field field) {
        String methodName = "get" + field.getName();
        for (Method method : field.getDeclaringClass().getMethods()) {
            if (method.getParameterTypes().length != 0 || !method.getName().equalsIgnoreCase(methodName) || !method.getReturnType().isAssignableFrom(field.getType())) continue;
            return method;
        }
        return null;
    }

    private boolean isTrack(ProceedingJoinPoint point) {
        if (point.getSignature() instanceof MethodSignature) {
            MethodSignature methodSignature = (MethodSignature)point.getSignature();
            for (Annotation annotation : methodSignature.getMethod().getAnnotations()) {
                if (!(annotation instanceof MethodLoggerConfig)) continue;
                MethodLoggerConfig methodLoggerConfig = (MethodLoggerConfig)annotation;
                return methodLoggerConfig.value();
            }
        }
        return true;
    }

    private boolean isLogWithError(ProceedingJoinPoint point) {
        if (point.getSignature() instanceof MethodSignature) {
            MethodSignature methodSignature = (MethodSignature)point.getSignature();
            for (Annotation annotation : methodSignature.getMethod().getAnnotations()) {
                if (!(annotation instanceof MethodLoggerConfig)) continue;
                MethodLoggerConfig methodLoggerConfig = (MethodLoggerConfig)annotation;
                return methodLoggerConfig.logWithError();
            }
        }
        return true;
    }

    private boolean isLogWithoutError(ProceedingJoinPoint point) {
        if (point.getSignature() instanceof MethodSignature) {
            MethodSignature methodSignature = (MethodSignature)point.getSignature();
            for (Annotation annotation : methodSignature.getMethod().getAnnotations()) {
                if (!(annotation instanceof MethodLoggerConfig)) continue;
                MethodLoggerConfig methodLoggerConfig = (MethodLoggerConfig)annotation;
                return methodLoggerConfig.logWithoutError();
            }
        }
        return true;
    }

    private int getMinDurationToLog(ProceedingJoinPoint point) {
        if (point.getSignature() instanceof MethodSignature) {
            MethodSignature methodSignature = (MethodSignature)point.getSignature();
            for (Annotation annotation : methodSignature.getMethod().getAnnotations()) {
                if (!(annotation instanceof MethodLoggerConfig)) continue;
                MethodLoggerConfig methodLoggerConfig = (MethodLoggerConfig)annotation;
                return methodLoggerConfig.minDurationToLog();
            }
        }
        return Integer.MIN_VALUE;
    }

    private boolean isLogParameter(Annotation[] annotations, Class<?> parameterType, String parameterName) {
        if (this.excludeClasses != null && parameterType != null && this.excludeClasses.contains(parameterType)) {
            return false;
        }
        if (this.excludeNames != null && parameterName != null && this.excludeNames.contains(parameterName)) {
            return false;
        }
        for (Annotation annotation : annotations) {
            if (!(annotation instanceof ParameterLoggerConfig)) continue;
            ParameterLoggerConfig parameterLoggerConfig = (ParameterLoggerConfig)annotation;
            return parameterLoggerConfig.value();
        }
        return true;
    }

    private boolean isLogMethodResponse(ProceedingJoinPoint point) {
        if (point.getSignature() instanceof MethodSignature) {
            MethodSignature methodSignature = (MethodSignature)point.getSignature();
            return this.isLogParameter(methodSignature.getMethod().getAnnotations(), methodSignature.getMethod().getReturnType(), null);
        }
        return true;
    }

    private String getBeanName(ProceedingJoinPoint point) throws Exception {
        try {
            Object target = point.getTarget();
            for (Method method : target.getClass().getMethods()) {
                if (!method.getName().equalsIgnoreCase("getBeanName") || method.getParameterTypes().length != 0) continue;
                return (String)method.invoke(target, new Object[0]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private static boolean contansObject(Object obj, List<Object> processedObjects) {
        for (Object o : processedObjects) {
            if (obj != o) continue;
            return true;
        }
        return false;
    }
}

