/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.remoting.hazelcast;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IExecutorService;
import com.hazelcast.core.ISet;
import com.hazelcast.core.Member;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import si.nevensrok.common.remoting.hazelcast.ServiceExporter;
import si.nevensrok.common.remoting.hazelcast.ServiceExporterKey;

public class ServiceRepository
implements InitializingBean,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(ServiceRepository.class);
    private static Map<String, ServiceRepository> repositories = new HashMap<String, ServiceRepository>();
    private String namePrefix = "remoting.";
    private HazelcastInstance hazelcastInstance;
    private List<ServiceExporter> serviceExporters;
    private Map<ServiceExporterKey, ServiceExporter> serviceExportMap = new HashMap<ServiceExporterKey, ServiceExporter>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ServiceRepository getServiceRepositoryForUuid(String uuid) {
        Map<String, ServiceRepository> map = repositories;
        synchronized (map) {
            return repositories.get(uuid);
        }
    }

    public void setNamePrefix(String namePrefix) {
        this.namePrefix = namePrefix;
    }

    public String getNamePrefix() {
        return this.namePrefix;
    }

    public void setHazelcastInstance(HazelcastInstance hazelcastInstance) {
        this.hazelcastInstance = hazelcastInstance;
    }

    public HazelcastInstance getHazelcastInstance() {
        return this.hazelcastInstance;
    }

    public void setServiceExporters(List<ServiceExporter> serviceExporters) {
        this.serviceExporters = serviceExporters;
    }

    public List<ServiceExporter> getServiceExporters() {
        return this.serviceExporters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterPropertiesSet() throws Exception {
        if (this.hazelcastInstance == null) {
            throw new IllegalArgumentException("Property 'hazelcastInstance' is requied");
        }
        log.debug("Local uuid: {}", (Object)this.getLocalUuid());
        Map<String, ServiceRepository> map = repositories;
        synchronized (map) {
            repositories.put(this.getLocalUuid(), this);
        }
        if (this.serviceExporters != null) {
            for (ServiceExporter serviceExporter : this.serviceExporters) {
                this.serviceExportMap.put(new ServiceExporterKey(serviceExporter), serviceExporter);
                String setName = this.namePrefix + "service." + serviceExporter.getInterfaceClass() + "[" + serviceExporter.getVersion() + "]";
                ISet serviceProvidersMap = this.hazelcastInstance.getSet(setName);
                serviceProvidersMap.add(this.getLocalUuid());
                if (!log.isDebugEnabled()) continue;
                log.debug("Service provider map for {}: {}", new Object[]{setName, serviceProvidersMap.toArray(new String[0])});
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() throws Exception {
        Map<String, ServiceRepository> map = repositories;
        synchronized (map) {
            repositories.remove(this.getLocalUuid());
        }
    }

    private String getLocalUuid() {
        return this.hazelcastInstance.getCluster().getLocalMember().getUuid();
    }

    private Member getMemberByUuid(String uuid) {
        for (Member member : this.hazelcastInstance.getCluster().getMembers()) {
            if (!member.getUuid().equals(uuid)) continue;
            return member;
        }
        return null;
    }

    public List<Member> getMembersFor(String className, String version) {
        LinkedList<Member> members = new LinkedList<Member>();
        String setName = this.namePrefix + "service." + className + "[" + version + "]";
        ISet serviceProvidersMap = this.hazelcastInstance.getSet(setName);
        if (log.isTraceEnabled()) {
            log.trace("Found service provider map for {}: {}", new Object[]{setName, serviceProvidersMap.toArray(new String[0])});
        }
        for (String uuid : serviceProvidersMap) {
            Member member = this.getMemberByUuid(uuid);
            if (member == null) continue;
            members.add(member);
        }
        return members;
    }

    public IExecutorService getExecutorService() {
        return this.hazelcastInstance.getExecutorService(this.namePrefix + "executorService");
    }

    public ServiceExporter getServiceExporterFor(String className, String version) {
        return this.serviceExportMap.get(new ServiceExporterKey(className, version));
    }
}

