/*
 * Copyright (c) 2008-present Sonatype, Inc.
 *
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/pro/attributions
 * Sonatype and Sonatype Nexus are trademarks of Sonatype, Inc. Apache Maven is a trademark of the Apache Foundation.
 * M2Eclipse is a trademark of the Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Docker controller.
 *
 * @since 3.16
 */
Ext.define('NX.docker.controller.DockerDependencySnippetController', {
  extend: 'NX.app.Controller',

  /**
   * @override
   */
  init: function() {
    NX.getApplication().getDependencySnippetController()
        .addDependencySnippetGenerator('docker', this.snippetGenerator);
  },

  snippetGenerator: function(componentModel, assetModel) {
    var yamlIndent = '  '
    var name = componentModel.get('name'),
        shortName = name.substring(name.lastIndexOf('/') + 1),
        version = componentModel.get('version');

    return [
      {
        displayName: 'Docker',
        snippetText: 'docker pull ' + name + ':' + version
      }, {
        displayName: 'Dockerfile',
        snippetText: 'FROM ' + name + ':' + version
      }, {
        displayName: 'Compose',
        snippetText: 'services:\n' +
            yamlIndent + shortName + ':\n' +
            yamlIndent.repeat(2) + 'image: ' + name + ':' + version
      }, {
        displayName: 'Kubernetes',
        snippetText: 'spec:\n' +
            yamlIndent + 'containers:\n' +
            yamlIndent + '- name: ' + shortName + '\n' +
            yamlIndent.repeat(2) + 'image: ' + name + ':' + version
      }
    ];
  }
});
