Ext.define("NX.proui.app.PluginStrings",{"@aggregate_priority":90,singleton:true,requires:["NX.I18n"],keys:{Crowd_Text:"Atlassian Crowd",Crowd_Description:"Manage Atlassian Crowd configuration",Crowd_CrowdSettings_Update_Error:"You do not have permission to configure Atlassian Crowd",Crowd_CrowdSettings_Update_Success:"Atlassian Crowd settings $action",Crowd_CrowdSettings_Html:'<p>Application can be configured to use <a href="https://www.atlassian.com/software/crowd" target="_blank" rel="noopener">Atlassian Crowd</a> for user database and authentication.</p>',Crowd_CrowdSettings_Enable_FieldLabel:"Enable Crowd",Crowd_CrowdSettings_Activate_FieldLabel:"Enable Crowd Realm for authentication",Crowd_CrowdSettings_Activate_HelpText:'To control ordering, go to the <a href="#admin/security/realms">Realms</a> page.',Crowd_CrowdSettings_URL_FieldLabel:"Crowd server URL",Crowd_CrowdSettings_URL_HelpText:"For example: http://localhost:8095/crowd",Crowd_CrowdSettings_Name_FieldLabel:"Crowd application name",Crowd_CrowdSettings_Password_FieldLabel:"Crowd application password",Crowd_CrowdSettings_Request_FieldLabel:"Connection timeout",Crowd_CrowdSettings_Request_HelpText:"Seconds to wait for activity before stopping and retrying the connection. Leave blank to use the globally defined HTTP timeout.",Crowd_CrowdSettings_VerifyConnection_Text:"Verify connection",Crowd_CrowdSettings_Verified_Success:"Connection to Crowd server verified: {0}",Crowd_CrowdSettings_ClearCache_Text:"Clear cache",Crowd_CrowdSettings_ClearCache_Success:"Crowd cache has been cleared",UserToken_Text:"User Token",UserToken_Description:"Manage user token configuration",UserTokenSettings_Update_Error:"You do not have permission to configure user token",UserTokenSettings_Update_Success:"User Token settings $action",UserTokenSettings_Html:'<p>The user token feature allows users to authenticate securely without typical user credentials such as those used by LDAP or Crowd.</p><p>User tokens generated for this server are only valid for use on this server. Once enabled, users can access their user token from <a href="#user/usertoken">user mode</a>.</p>',UserTokenSettings_Enable_FieldLabel:"Enable user tokens",UserTokenSettings_Require_FieldLabel:"Require user tokens for repository authentication",UserTokenSettings_Require_HelpText:"This does not affect UI access",UserTokenSettings_Reset_Title:"Reset user tokens",UserTokenSettings_Reset_Html:"<p>Reset will invalidate <b>ALL</b> existing user tokens and force new tokens to be created the next time they are accessed.</p>",UserTokenSettings_ResetAll_Button:"Reset all user tokens",UserToken_Authentication_Validation:"{0} user tokens requires validation of your credentials.",UserToken_ResetAll_Success:"All user tokens have been reset",UserToken_Reset_Success:"Your user token has been reset",UserToken_ResetById_Message:"User token of {0} has been reset",UserToken_UserTokenUser_Title:"User Token",UserToken_UserTokenUser_ResetToken_Title:"Reset user token",UserToken_UserTokenUser_ResetToken_Html:"<p>Resetting a user’s token will invalidate their current token and force a new token to be created the next time it is accessed by the user.</p>",UserToken_UserTokenUser_ResetToken_Button:"Reset user token",HealthCheckInfo_Security_Alerts_Label:"Security",HealthCheckInfo_License_Threat_Label:"License ",HealthCheckInfo_Tooltip:"License and security data is only available with a paid license.",HealthCheckInfo_LoggedInOnly_Tooltip:"The license and security data is only available once you have logged in.",HealthCheckInfo_NoPermission_Tooltip:"You do not have permission to view the license and security data.",FirewallRepositoryColumn_Header:"Firewall Report",FirewallRepositoryColumn_Loading:"Loading&hellip;",FirewallRepositoryColumn_NoViolations:"No violations",DatabaseQuorumReset_Title:"Cluster Reset",DatabaseQuorumResetConfirm_Resetting:"Resetting Cluster Size",DatabaseQuorumReset_Description:"Take your cluster down to a single node",DatabaseQuorumReset_ResetButton:"Reset Database Quorum",DatabaseQuorumResetConfirm_Title:"Confirm Cluster Reset",DatabaseQuorumResetConfirm_HelpText:"Have you ensured that other nodes in the cluster are shut down? Resetting the quorum can result in corrupt data if other nodes are still online.",DatabaseQuorumResetConfirm_Fail:"Failed to reset database cluster quorum setting!",DatabaseQuorumResetConfirm_GetLocalNode_Fail:"Unable to detect which node you are currently connected to",DatabaseQuorumResetConfirm_LocalNodeNotKnown:"Cannot reset database cluster quorum setting, the current node is unidentified",DatabaseQuorumResetConfirm_Success:"The database cluster write quorum was reset to one node",DatabaseQuorumResetConfirm_Yes:"Reset Quorum",DatabaseQuorumResetConfirm_No:"@Button_Cancel",ComponentTags_TagTitle:"Component Tags",ComponentTags_NoTagsFound:"No tags found",ComponentTags_NoTagsFound_Long:'<div class="summary">There are no tags created yet<br><span style="font-weight: lighter; font-size: small;">or you don\'t have permission to browse them</span></div><div class="panel nx-subsection"><h3 class="title"><span class="icon"></span>What is a tag?</h3><p>Tagging is a feature available in Nexus Repository Manager Pro that provides the ability to mark a set of components with a tag so they can be logically associated to each other. The usage of the tags is up to you but the most common scenarios would be a CI build ID for a project (e.g. project-abc-build-142) or a higher level release train when you are coordinating multiple projects together as a single unit (e.g. release-train-13). Tagging is used extensively by the <a href="http://links.sonatype.com/products/nxrm3/docs/staging" target="_blank" rel="noopener noreferrer">staging</a> feature. For more information, check <a href="http://links.sonatype.com/products/nxrm3/docs/component-tag" target="_blank" rel="noopener noreferrer">the documentation</a>.</p></div>',ComponentTags_ClickForDetails:"Click row to view details in a new window",ComponentTags_TagNameHeader:"Tag Name",ComponentTags_FirstCreatedHeader:"First Created Time",ComponentTags_LastUpdatedHeader:"Last Updated Time",Tags_Description:"View created tags",Tags_Title:"Tags",Tags_EmptyText:"No tags found.",TagFeature_FindTaggedComponents_Button:"Find Tagged Components",TagPanel_Attributes_Label:"Attributes",TagPanel_FirstCreated_Label:"First Created Time",TagPanel_LastUpdated_Label:"Last Updated Time",GroupDeployment_Docker_Help:'<em>Deploying through a group repository has different behaviors than deploying directly to a hosted repository. Read our <a href="http://links.sonatype.com/products/nxrm3/docs/pushing-images" target="_blank">documentation</a> for more details.</em>',Starter_Edition:"PRO-STARTER",Total_Components_Tooltip:"Sonatype Nexus Repository's Pro Starter version only supports up to {} components. Upgrade to Pro with a PostgreSQL database for unlimited component support.",Requests_Per_Day_Tooltip:"Sonatype Nexus Repository's Pro Starter version only supports up to {} requests per day to repository endpoints for all repositories. Upgrade to Pro with a PostgreSQL database for unlimited requests.",Exceeding_Threshold_Requests_Per_Day_Prefix:"Users can not currently upload to this repository. This repository has hit the maximum of {} peak requests in the past 30 days. ",Exceeding_Threshold_Requests_Per_Day_Mid:" and consider ",Exceeding_Threshold_Total_Components_Prefix:"Users can not currently upload to this repository. This repository contains the maximum of {} components. ",Exceeding_Threshold_Total_Components_Mid:" and consider removing unused components or ",Approaching_Threshold_Requests_Per_Day_Prefix:"This repository is approaching the maximum of {} peak requests in the past 30 days. Users will not be able to upload to this repository after reaching this limit. ",Approaching_Threshold_Requests_Per_Day_Mid:" and consider ",Approaching_Threshold_Total_Components_Prefix:"This repository is approaching the maximum of {} components. Users will not be able to upload to this repository after reaching this limit. ",Approaching_Threshold_Total_Components_Mid:" and consider removing unused components or ",Suffix:" for unlimited usage.",}},function(a){NX.I18n.register(a)});Ext.define("NX.proui.app.PluginConfig",{"@aggregate_priority":100,requires:["NX.State","NX.proui.app.PluginStrings"],controllers:[{id:"NX.proui.controller.ComponentTags",active:function(){return NX.app.Application.bundleActive("com.sonatype.nexus.plugins.nexus-tags-plugin")}},{id:"NX.proui.controller.HealthCheckRepositoryDetail",active:function(){return NX.app.Application.bundleActive("com.sonatype.nexus.plugins.nexus-clm-plugin")}},{id:"NX.proui.controller.HealthCheckAssetDetail",active:function(){return NX.app.Application.bundleActive("com.sonatype.nexus.plugins.nexus-clm-plugin")}},{id:"NX.proui.controller.HealthCheckInfo",active:function(){return NX.app.Application.bundleActive("com.sonatype.nexus.plugins.nexus-clm-plugin")}},{id:"NX.proui.controller.UserToken",active:function(){return NX.State.getValue("usertoken",{})["licenseValid"]&&NX.app.Application.bundleActive("com.sonatype.nexus.plugins.nexus-usertoken-plugin")}},{id:"NX.proui.controller.DatabaseQuorumReset",active:function(){return true}},{id:"NX.proui.controller.Tags",active:function(){return NX.app.Application.bundleActive("com.sonatype.nexus.plugins.nexus-tags-plugin")}}]});Ext.define("NX.proui.view.usertoken.UserTokenUser",{extend:"NX.view.SettingsPanel",alias:"widget.nx-proui-usertoken-user",requires:["NX.I18n"],initComponent:function(){Ext.apply(this,{title:NX.I18n.get("UserToken_UserTokenUser_Title"),settingsForm:[{xtype:"nx-settingsform",itemId:"resetAll",title:NX.I18n.get("UserToken_UserTokenUser_ResetToken_Title"),items:[{xtype:"label",html:NX.I18n.get("UserToken_UserTokenUser_ResetToken_Html")}],buttonAlign:"left",buttons:[{text:NX.I18n.get("UserToken_UserTokenUser_ResetToken_Button"),action:"reset",ui:"nx-primary",iconCls:"x-fa fa-lock"}]}]});this.callParent()}});Ext.define("NX.proui.model.Tag",{extend:"Ext.data.Model",fields:[{name:"id",type:"string",sortType:"asUCText"},{name:"lastUpdatedTime",type:"string"},{name:"firstCreatedTime",type:"string"}]});Ext.define("NX.proui.view.tags.TagList",{extend:"NX.view.drilldown.Master",alias:"widget.nx-proui-tags-list",requires:["NX.I18n"],stateful:true,stateId:"nx-proui-tags-list",tbar:{xtype:"nx-actions"},initComponent:function(){Ext.apply(this,{store:"Tags",viewConfig:{emptyText:NX.I18n.get("ComponentTags_NoTagsFound_Long"),deferEmptyText:false},columns:[{text:NX.I18n.get("ComponentTags_TagNameHeader"),dataIndex:"id",flex:2.5,renderer:Ext.htmlEncode},{text:NX.I18n.get("ComponentTags_FirstCreatedHeader"),dataIndex:"firstCreatedTime",flex:2.5,renderer:function(a){return new Date(a).toLocaleString()}},{text:NX.I18n.get("ComponentTags_LastUpdatedHeader"),dataIndex:"lastUpdatedTime",flex:2.5,renderer:function(a){return new Date(a).toLocaleString()}}],plugins:[{ptype:"gridfilterbox",emptyText:NX.I18n.get("Tags_EmptyText")}]});this.callParent()}});Ext.define("NX.proui.view.tags.TagPanel",{extend:"Ext.panel.Panel",alias:"widget.nx-proui-tag-panel",autoScroll:true,requires:["NX.I18n"],cls:"nx-hr",ui:"nx-inset",layout:{type:"vbox",align:"stretch"},title:"Details",loadRecord:function(a){var b=this;b.removeAll(true);NX.direct.proui_TagList.getTag(a.get("id"),function(e){var d=[],c=e.data;if(!e.success){return}d.push(b.createTextField(NX.I18n.get("TagPanel_FirstCreated_Label"),new Date(c.firstCreatedTime).toLocaleString()));d.push({xtype:"label",html:"&nbsp;"});d.push(b.createTextField(NX.I18n.get("TagPanel_LastUpdated_Label"),new Date(c.lastUpdatedTime).toLocaleString()));d.push({xtype:"label",html:"&nbsp;"});d.push(b.createHtmlField(NX.I18n.get("TagPanel_Attributes_Label"),b.toJsonText(c.attributes)));b.add({ui:"nx-subsection",frame:true,xtype:"panel",layout:{type:"vbox",align:"stretch"},items:d});b.fireEvent("recordloaded",b,a)})},createTextField:function(a,b){return this.createHtmlField(a,Ext.htmlEncode(b))},createHtmlField:function(a,b){return{items:[{xtype:"label",html:"<b>"+Ext.htmlEncode(a)+":</b>"},{xtype:"label",html:b}],xtype:"panel",layout:"vbox",frame:false,ui:"nx-subsection"}},toJsonText:function(a){return"<pre>"+Ext.htmlEncode(JSON.stringify(a,null,2))+"</pre>"}});Ext.define("NX.proui.model.ComponentTags",{extend:"Ext.data.Model",fields:[{name:"id",type:"string",sortType:"asUCText"},{name:"lastUpdatedTime",type:"string"},{name:"firstCreatedTime",type:"string"},{name:"url",type:"string"},{name:"details",type:"string"}]});Ext.define("NX.proui.store.ComponentTags",{extend:"Ext.data.Store",model:"NX.proui.model.ComponentTags",proxy:{type:"direct",api:{read:"NX.direct.proui_TagList.readTagListDetails"},reader:{type:"json",rootProperty:"data",successProperty:"success"}},autoLoad:false,sorters:{property:"id",direction:"ASC"}});Ext.define("NX.proui.view.database.DatabaseQuorumResetConfirm",{extend:"NX.view.SettingsPanel",alias:"widget.nx-proui-database-quorum-reset",requires:["NX.I18n"],initComponent:function(){var a=this;Ext.apply(a,{settingsForm:{xtype:"nx-settingsform",items:[{xtype:"label",html:'<h3>Resetting the Database Write Quorum</h3><p>Resetting the database write quorum is not meant to fix all problems related to Nexus clustering. However it can be used if you would like to reduce your cluster down to a single node and rebuild your cluster.</p><p>It is important to understand the implications of resetting the write quorum. In doing so, you will move from having a "cluster" to only having one working node. If that is your intention, then we suggest that you first attempt to shut down any other running Nexus nodes.</p><p>To recreate your cluster after resetting the write quorum, you will need to reattach nodes to the cluster. The new nodes that join your cluster, after resetting the write quorum, may need to replicate all of the Nexus databases. This may consume considerable time and resources.</p>'}],buttonAlign:"left",buttons:[{xtype:"button",text:NX.I18n.get("DatabaseQuorumReset_ResetButton"),iconCls:"x-fa fa-download",action:"resetQuorum"}]}});a.callParent()}});Ext.define("NX.proui.view.tags.ComponentTags",{extend:"Ext.grid.Panel",alias:"widget.nx-proui-tags-taglistdetails",requires:["NX.I18n"],manageHeight:false,store:"ComponentTags",initComponent:function(){Ext.apply(this,{store:"ComponentTags",loadStore:Ext.emptyFn,allowDeselect:true,viewConfig:{emptyText:NX.I18n.get("ComponentTags_NoTagsFound"),deferEmptyText:false},columns:[{text:NX.I18n.get("ComponentTags_TagNameHeader"),dataIndex:"id",renderer:Ext.htmlEncode,flex:2.5},{text:NX.I18n.get("ComponentTags_FirstCreatedHeader"),dataIndex:"firstCreatedTime",flex:2.5,renderer:function(a){return new Date(a).toLocaleString()}},{text:NX.I18n.get("ComponentTags_LastUpdatedHeader"),dataIndex:"lastUpdatedTime",flex:2.5,renderer:function(a){return new Date(a).toLocaleString()}}]});this.on("itemclick",function(b,a){var c=Ext.create("NX.Bookmark");c.applyToken("browse/tags");c.appendSegments(a.id);NX.Bookmarks.navigateTo(c)});this.callParent()}});Ext.define("NX.proui.controller.ComponentTags",{extend:"NX.app.Controller",requires:["NX.Permissions","NX.State"],views:["tags.ComponentTags"],models:["ComponentTags"],stores:["ComponentTags"],init:function(){var a=this;a.listen({component:{"nx-coreui-component-componentassetinfo":{updated:a.onComponentAssetInfoUpdated},"nx-coreui-component-assetcontainer":{updated:a.onAssetContainerInfoUpdated},"nx-coreui-component-componentinfo":{updated:a.onComponentInfoUpdated}}})},onAssetContainerInfoUpdated:function(b,c){var d=this;var a=b.down("nx-proui-tags-taglistdetails");if(this.isTaggingEnabled()){if(!a){b.addTab({xtype:"nx-proui-tags-taglistdetails",ui:"nx-inset",title:NX.I18n.get("ComponentTags_TagTitle"),itemId:"taglistdetails",weight:40,autoScroll:true})}d.loadComponentData(c.get("componentId"),c.get("repositoryName"))}else{b.remove(a)}},onComponentAssetInfoUpdated:function(a,c,b){this.onComponentUpdated(a,b.get("id"),b.get("repositoryName"))},onComponentInfoUpdated:function(a,b){this.onComponentUpdated(a,b.get("id"),b.get("repositoryName"))},onComponentUpdated:function(b,c,e){var d=this;var a=b.down("nx-proui-tags-taglistdetails");if(this.isTaggingEnabled()){if(!a){b.add({xtype:"nx-proui-tags-taglistdetails",ui:"nx-inset",title:NX.I18n.get("ComponentTags_TagTitle"),itemId:"tagPanel",weight:20,autoScroll:true,collapsible:true})}d.loadComponentData(c,e)}else{b.remove(a)}},loadComponentData:function(b,d){var c=this;var a=c.getStore("ComponentTags");a.load({params:{filter:[{property:"componentId",value:b},{property:"repositoryName",value:d}]},scope:this})},isTaggingEnabled:function(){var a=NX.State.getEdition();return NX.State.getUser()&&NX.Permissions.check("nexus:tags:read")&&!("EVAL"===a||"OSS"===a)}});Ext.define("NX.proui.view.usertoken.UserTokenSettings",{extend:"NX.view.SettingsPanel",alias:"widget.nx-proui-usertoken-settings",requires:["NX.Conditions","NX.I18n"],initComponent:function(){Ext.apply(this,{settingsForm:[{xtype:"nx-settingsform",settingsFormSuccessMessage:NX.I18n.get("UserTokenSettings_Update_Success"),api:{load:"NX.direct.usertoken_UserToken.read",submit:"NX.direct.usertoken_UserToken.update"},editableCondition:NX.Conditions.isPermitted("nexus:usertoken-settings:update"),editableMarker:NX.I18n.get("UserTokenSettings_Update_Error"),items:[{xtype:"label",html:NX.I18n.get("UserTokenSettings_Html")},{xtype:"checkbox",name:"enabled",fieldLabel:NX.I18n.get("UserTokenSettings_Enable_FieldLabel")},{xtype:"checkbox",name:"protectContent",fieldLabel:NX.I18n.get("UserTokenSettings_Require_FieldLabel"),helpText:NX.I18n.get("UserTokenSettings_Require_HelpText")}]},{xtype:"form",ui:"nx-subsection",frame:true,itemId:"resetAll",title:NX.I18n.get("UserTokenSettings_Reset_Title"),hidden:true,items:[{xtype:"label",html:NX.I18n.get("UserTokenSettings_Reset_Html")}],buttonAlign:"left",buttons:[{text:NX.I18n.get("UserTokenSettings_ResetAll_Button"),action:"resetall",ui:"nx-primary",iconCls:"x-fa fa-lock"}]}]});this.callParent()}});Ext.define("NX.proui.controller.UserToken",{extend:"NX.app.Controller",requires:["NX.Conditions","NX.Messages","NX.Permissions","NX.Security","NX.State","NX.I18n"],views:["usertoken.UserTokenSettings","usertoken.UserTokenUser"],refs:[{ref:"userUserTokenPanel",selector:"nx-coreui-user-feature nx-proui-usertoken-user"}],init:function(){var a=this;a.getApplication().getIconController().addIcons({"feature-usertoken":{file:"key.png",variants:["x16","x32"]},"usertoken-default":{file:"key.png",variants:["x16","x32"]}});a.listen({component:{"nx-proui-usertoken-settings button[action=resetall]":{click:a.resetAll,afterrender:a.bindResetAllButton},"nx-proui-usertoken-settings nx-settingsform":{loaded:a.onLoaded,submitted:a.onSubmitted},"nx-coreui-user-list":{beforerender:a.bindUserUserTokenTab,selection:a.onUserSelection},"nx-proui-usertoken-user button[action=reset]":{click:a.reset,afterrender:a.bindResetButton}}})},onLoaded:function(a,b){var c=a.up("nx-proui-usertoken-settings").down("#resetAll");if(b.result.data.enabled){c.show()}else{c.hide()}},onSubmitted:function(a,b){NX.State.setValue("usertoken",Ext.apply(NX.State.getValue("usertoken",{}),{enabled:b.result.data.enabled}))},onUserSelection:function(c,b){var a=this.getUserUserTokenPanel();if(Ext.isDefined(b)&&a){a.down("form").loadRecord(b)}},bindUserUserTokenTab:function(b){var a=this;b.mon(NX.Conditions.watchState("usertoken",function(c){return c&&c.enabled}),{satisfied:function(){var c=a.getUserUserTokenPanel();if(!c){a.fireEvent("userSettingsAddTab",{xtype:"nx-proui-usertoken-user"})}},unsatisfied:function(){var c=a.getUserUserTokenPanel();if(c){a.fireEvent("userSettingsRemoveTab",{xtype:"nx-proui-usertoken-user"})}},scope:a})},bindResetAllButton:function(a){a.mon(NX.Conditions.and(NX.Conditions.isPermitted("nexus:usertoken-users:delete")),{satisfied:function(){a.enable()},unsatisfied:function(){a.disable()}})},bindResetButton:function(a){a.mon(NX.Conditions.and(NX.Conditions.isPermitted("nexus:usertoken-user:delete")),{satisfied:function(){a.enable()},unsatisfied:function(){a.disable()}})},resetAll:function(){NX.Security.doWithAuthenticationToken(NX.I18n.format("UserToken_Authentication_Validation","Resetting"),{success:function(a){NX.direct.usertoken_UserToken.resetAll(a,function(b){if(Ext.isDefined(b)&&b.success){NX.Messages.success(NX.I18n.get("UserToken_ResetAll_Success"))}})}})},reset:function(a){var c=a.up("form"),b=c.getRecord();NX.Security.doWithAuthenticationToken(NX.I18n.format("UserToken_Authentication_Validation","Resetting"),{success:function(d){NX.direct.usertoken_UserToken.reset(d,b.get("userId"),b.get("realm"),function(e){var f="";if(Ext.isDefined(e)&&e.success){NX.Messages.success(NX.I18n.format("UserToken_ResetById_Message",b.get("userId")))}else{if(Ext.isDefined(e.errors)){Object.keys(e.errors).forEach(function(g){f+=g+" "+e.errors[g]+". "});NX.Messages.warning(f)}}})}})}});Ext.define("NX.proui.controller.HealthCheckInfo",{extend:"NX.app.Controller",requires:["NX.Conditions","NX.Permissions","NX.State","NX.util.Url","NX.I18n","NX.coreui.util.HealthCheckUtil"],init:function(){var a=this;a.listen({component:{"nx-coreui-component-details":{healthCheckLoaded:a.renderHealthCheckFields},"nx-coreui-component-componentinfo":{healthCheckLoaded:a.renderComponentInfoHealthCheckFields},"nx-coreui-component-componentassetinfo":{healthCheckLoaded:a.renderComponentInfoHealthCheckFields}}})},renderHealthCheckFields:function(a,b){var c=this,d,e={};if(b){d=a.down("#healthCheckInfoPro");if(!d){d=a.add({xtype:"nx-info",itemId:"healthCheckInfoPro"})}e[NX.I18n.get("HealthCheckInfo_Security_Alerts_Label")]=c.renderSecurityAlerts(b);e[NX.I18n.get("HealthCheckInfo_License_Threat_Label")]=c.renderLicenseThreat(b);d.showInfo(e)}},renderComponentInfoHealthCheckFields:function(a,b){var c=this;if(b){a.setInfo("healthCheckInfoPro",NX.I18n.get("HealthCheckInfo_Security_Alerts_Label"),c.renderSecurityAlerts(b));a.setInfo("healthCheckInfoPro",NX.I18n.get("HealthCheckInfo_License_Threat_Label"),c.renderLicenseThreat(b));a.showInfo()}},renderSecurityAlerts:function(c){var f=this,g={},i,b,h,e,a,d=function(j,k){return'<span class="nx-clm-chiclet-small '+j+'">'+k+"</span>"};i=f.renderPreconditions(c,g);if(!i){b=c.get("healthCheckSecurityAlerts");h=c.get("healthCheckCriticalSecurityAlerts");e=c.get("healthCheckSevereSecurityAlerts");a=c.get("healthCheckModerateSecurityAlerts");if(b===0||b>0){i=d(h>0?"critical":"",h>0?h:"")+d(e>0?"severe":"",e>0?e:"")+d(a>0?"moderate":"",a>0?a:"")}if(!Ext.isDefined(i)){i=f.renderNotAvailable(g)}}return"<div "+(g.attr||"")+">"+i+"</div>"},renderLicenseThreat:function(b){var f=this,c={},a,e,d,g="";a=f.renderPreconditions(b,c);if(!a){e=b.get("healthCheckLicenseThreat");d=b.get("healthCheckLicenseThreatName");if(e===0||e>0){if(e===4){g="critical"}else{if(e===2){g="moderate"}else{if(e===1){g="none"}else{g="severe"}}}return'<span class="nx-clm-chiclet-small '+g+'" style="width: auto; padding: 1px 2px; font-size: inherit;">'+d+"</span>"}if(!Ext.isDefined(a)){a=f.renderNotAvailable(c)}}return"<div "+(c.attr||"")+">"+a+"</div>"},renderPreconditions:function(b,c){var d=NX.State.getEdition(),a=NX.coreui.util.HealthCheckUtil;if("EVAL"===d||"OSS"===d){c.attr='data-qtip="'+NX.I18n.get("HealthCheckInfo_Tooltip")+'"';return a.iconSpan("fa-lock","opacity: 0.33;")}else{if(!NX.State.getUser()){c.attr='data-qtip="'+NX.I18n.get("HealthCheckInfo_LoggedInOnly_Tooltip")+'"';return a.iconSpan("fa-lock","opacity: 0.33;")}else{if(!NX.Permissions.check("nexus:healthcheckalerts:update")){c.attr='data-qtip="'+NX.I18n.get("HealthCheckInfo_NoPermission_Tooltip")+'"';return a.iconSpan("fa-lock","opacity: 0.33;")}else{if(b.get("healthCheckLoading")){return NX.I18n.get("HealthCheckInfo_Loading_Text")}else{if(b.get("healthCheckDisabled")){c.attr='data-qtip="'+NX.I18n.get("HealthCheckInfo_Disabled_Tooltip")+'"';return a.iconSpan("fa-info-circle","opacity: 0.33;")}else{if(b.get("healthCheckError")){c.attr='data-qtip="'+NX.I18n.get("HealthCheckInfo_Error_Tooltip")+'"';return a.iconSpan("fa-exclamation-triangle","color: red;")}else{if(b.get("healthCheckCapped")||(b&&b.get("cappedAlerts"))){c.attr='data-qtip="'+NX.I18n.get("HealthCheckInfo_Quota_Tooltip")+'"';return a.iconSpan("fa-exclamation-triangle","color: yellow;")}}}}}}}return undefined},renderNotAvailable:function(a){a.attr='data-qtip="'+NX.I18n.get("HealthCheckInfo_Unavailable_Tooltip")+'"';return NX.coreui.util.HealthCheckUtil.iconSpan("fa-ban","opacity: 0.33;")}});Ext.define("NX.proui.view.healthcheck.HealthCheckAssetDetail",{extend:"Ext.panel.Panel",alias:"widget.nx-proui-healthcheck-healthcheckassetdetail",requires:["NX.util.Base64","NX.util.Url","NX.Windows","NX.I18n"],ui:"nx-inset",layout:{type:"vbox",align:"stretch",pack:"start"},repositoryName:undefined,format:undefined,path:undefined,loaded:false,active:false,listeners:{afterrender:function(){var a=this;a.active=true;a.loadInfo()}},showInfo:function(a){var b=this;b.format=a.get("format");b.repositoryName=a.get("containingRepositoryName");b.path=a.get("name");b.loaded=false;b.loadInfo()},loadInfo:function(){var a=this;if(!a.loaded){a.removeAll();if(a.active&&a.rendered&&a.path){a.getEl().mask(NX.I18n.get("HealthCheckInfo_Loading_Text"));a.add([{xtype:"panel",ui:"nx-subsection",frame:true,minHeight:600,items:[{xtype:"box",border:false,autoEl:{tag:"iframe",src:NX.util.Url.urlOf("service/rest/healthcheck/healthCheckFileDetail/"+NX.util.Base64.encode(a.path)+"/"+NX.util.Base64.encode(a.repositoryName)+"/index.html?"+Ext.Object.toQueryString({format:a.format})),width:"100%",height:"100%",scrolling:"auto"},listeners:{afterrender:function(b){a.loaded=true;b.getEl().on({load:function(){var c=b.getEl().dom.contentWindow.Insight;a.getEl().unmask();if(c){a.setClmComponent(c);a.registerClmViewDetailsListener(c)}}})}}}]}])}}},setClmComponent:function(a){var b=this;NX.direct.healthcheck_AssetDetail.identify(b.repositoryName,b.path,function(c){if(Ext.isObject(c)){if(c.success){var e=c.data.componentIdentifier.format,f=c.data.componentIdentifier.coordinates,d=c.data.hash;if(b.isLegacyClm(a)){b.setLegacyClmComponent(a,e,f,d)}else{a.setCoordinates(e,f,{hash:d})}}else{a.setError({errorMessage:"Unable to identify component: "+c.message,errorCode:400})}}else{a.setError({errorMessage:"Unable to identify component",errorCode:500})}},undefined,{skipResultCheck:true})},setLegacyClmComponent:function(a,c,d,b){if(c!=="maven"){a.setError({errorMessage:"Unsupported repository format, please upgrade to Nexus IQ Server 1.13 or greater.",errorCode:400});return}a.setGav({groupId:d.groupId,artifactId:d.artifactId,version:d.version,extension:d.extension,classifier:d.classifier,hash:b})},registerClmViewDetailsListener:function(a){var b=this;if(b.isLegacyClm(a)){b.registerLegacyClmViewDetailsListener(a)}else{a.registerCoordsViewDetailsListener(function(h,g,j,f){var c={format:g,coordinates:{}},e={appId:h,hash:f};if(j){for(var d=0;d<j.length;d+=2){c.coordinates[j[d]]=j[d+1]}}e.componentIdentifier=JSON.stringify(c);if(j){NX.Windows.open(NX.util.Url.urlOf("viewdetails.html?"+Ext.Object.toQueryString(e)))}})}},registerLegacyClmViewDetailsListener:function(a){a.registerViewDetailsListener(function(g,c,i,b,f,h,e){var d={appId:g,hash:e,groupId:c,artifactId:i,version:b,classifier:f,extension:h};NX.Windows.open(NX.util.Url.urlOf("viewdetails.html?"+Ext.Object.toQueryString(d)))})},showDetails:function(d,c,b,a){Sonatype.view.mainTabPanel.addOrShowTab(me.toTabId(d,c,b,a),Nexus.clm.ComponentDetailView,{title:"IQ Server Detail",appId:d,hash:c,component:!a?b:null,gav:a?b.coordinates:null})},isLegacyClm:function(a){return !(a.registerCoordsViewDetailsListener||a.setCoordinates)}});Ext.define("NX.proui.controller.HealthCheckAssetDetail",{extend:"NX.app.Controller",requires:["NX.Permissions","NX.State"],views:["healthcheck.HealthCheckAssetDetail"],init:function(){var a=this;a.listen({component:{"nx-coreui-component-assetcontainer":{updated:a.onAssetContainerUpdated},"nx-coreui-component-componentassetinfo":{updated:a.onComponentAssetInfoUpdated}}})},onAssetContainerUpdated:function(b,c){var d=Boolean((c.get("componentId")&&c.get("componentId").trim()));var a=b.down("nx-proui-healthcheck-healthcheckassetdetail");if(this.isHealthCheckEnabled()&&d){if(!a){b.addTab({xtype:"nx-proui-healthcheck-healthcheckassetdetail",title:NX.I18n.get("Component_AssetInfo_HealthCheck_Title"),itemId:"healthCheckInfo",weight:50});a=b.down("nx-proui-healthcheck-healthcheckassetdetail")}a.showInfo(c)}else{if(a){b.remove(a)}}},onComponentAssetInfoUpdated:function(b,c){var d=Boolean((c.get("componentId")&&c.get("componentId").trim()));var a=b.down("nx-proui-healthcheck-healthcheckassetdetail");if(this.isHealthCheckEnabled()&&d){if(!a){a=b.add({xtype:"nx-proui-healthcheck-healthcheckassetdetail",title:NX.I18n.get("Component_AssetInfo_HealthCheck_Title"),itemId:"healthCheckInfo",weight:30,collapsible:true})}a.showInfo(c)}else{if(a){b.remove(a)}}},isHealthCheckEnabled:function(){var a=NX.State.getEdition();return NX.State.getUser()&&NX.Permissions.check("nexus:healthcheckalerts:read")&&!("EVAL"===a||"OSS"===a)}});Ext.define("NX.proui.controller.HealthCheckRepositoryDetail",{extend:"NX.app.Controller",requires:["NX.Permissions","NX.Windows"],init:function(){var a=this;a.listen({component:{"nx-coreui-healthcheck-summary":{afterrender:a.addDetailButton},"nx-coreui-healthcheck-summary button[action=viewdetail]":{click:a.viewDetail}}})},addDetailButton:function(c){var a=c.statusModel,b;if(a&&a.get("detailedReportSupported")){b=c.getDockedItems('toolbar[dock="bottom"]')[0];if(a.get("detailUrl")){b.add(["->",{xtype:"button",text:"View Detailed Report",action:"viewdetail",disabled:!NX.Permissions.check("nexus:healthcheckdetail:read")}])}else{b.add(["->","The next analysis will include the detailed report."])}}},viewDetail:function(b){var c=b.up("window"),a=c.statusModel;NX.Windows.open(a.get("detailUrl"));c.close()}});Ext.define("NX.proui.view.tags.TagFeature",{extend:"NX.view.drilldown.Drilldown",alias:"widget.nx-proui-tags-feature",requires:["NX.I18n"],initComponent:function(){Ext.apply(this,{iconCls:"x-fa fa-tag",masters:[{xtype:"nx-proui-tags-list"}],tabs:{xtype:"nx-proui-tag-panel"},nxActions:[{xtype:"button",text:NX.I18n.get("TagFeature_FindTaggedComponents_Button"),iconCls:"x-fa fa-search",action:"search",disabled:false}]});this.callParent()}});Ext.define("NX.proui.store.Tags",{extend:"Ext.data.Store",model:"NX.proui.model.Tag",proxy:{type:"direct",api:{read:"NX.direct.proui_TagList.readTags"},reader:{type:"json",rootProperty:"data",successProperty:"success"}},autoLoad:false,sorters:{property:"id",direction:"ASC"}});Ext.define("NX.proui.controller.DatabaseQuorumReset",{extend:"NX.app.Controller",requires:["NX.Permissions","NX.Messages","NX.I18n"],views:["database.DatabaseQuorumResetConfirm"],init:function(){var a=this;a.getApplication().getFeaturesController().registerFeature({mode:"admin",path:"/System/Nodes/Cluster Reset",text:NX.I18n.get("DatabaseQuorumReset_Title"),description:NX.I18n.get("DatabaseQuorumReset_Description"),view:{xtype:"nx-proui-database-quorum-reset"},visible:function(){var b=NX.State.getValue("quorum");return NX.Permissions.check("nexus:settings:update")&&b&&!b.quorumPresent}},a);a.listen({component:{"nx-proui-database-quorum-reset button[action=resetQuorum]":{click:a.resetQuorum}}});a.myNodeId=null;NX.direct.node_NodeAccess.nodes(function(b,c){if(Ext.isObject(b)&&b.success){b.data.forEach(function(d){if(d.local){a.myNodeId=d.name}})}else{if(c.xhr.status!==0){NX.Messages.warning(NX.I18n.get("DatabaseQuorumResetConfirm_GetLocalNode_Fail"))}}})},resetQuorum:function(){var a=this;if(a.myNodeId==null){NX.Messages.warning(NX.I18n.get("DatabaseQuorumResetConfirm_LocalNodeNotKnown"))}else{NX.Dialogs.askConfirmation(NX.I18n.get("DatabaseQuorumResetConfirm_Title"),NX.I18n.format("DatabaseQuorumResetConfirm_HelpText"),function(){NX.direct.proui_Database.resetQuorum(a.myNodeId,function(b){if(Ext.isObject(b)&&b.success){NX.Messages.success(NX.I18n.get("DatabaseQuorumResetConfirm_Success"));NX.Bookmarks.navigateTo(NX.Bookmarks.fromToken("admin/system/nodes"))}else{NX.Messages.warning(NX.I18n.get("DatabaseQuorumResetConfirm_Fail"))}})},{scope:a,buttonText:{yes:NX.I18n.get("DatabaseQuorumResetConfirm_Yes"),no:NX.I18n.get("DatabaseQuorumResetConfirm_No")}})}}});Ext.define("NX.proui.controller.Tags",{extend:"NX.controller.Drilldown",requires:["NX.Bookmarks","NX.Permissions","NX.I18n"],masters:["nx-proui-tags-list"],models:["Tag"],stores:["Tags"],views:["tags.TagFeature","tags.TagList","tags.TagPanel"],refs:[{ref:"feature",selector:"nx-proui-tags-feature"},{ref:"content",selector:"nx-feature-content"},{ref:"list",selector:"nx-proui-tags-list"},{ref:"settings",selector:"nx-proui-tags-feature nx-proui-tag-panel"}],permission:"nexus:tags",init:function(){var a=this;a.features={mode:"browse",path:"/tags",text:NX.I18n.get("Tags_Title"),description:NX.I18n.get("Tags_Description"),view:{xtype:"nx-proui-tags-feature"},iconCls:"x-fa fa-tags",visible:function(){return NX.Permissions.check("nexus:tags:read")&&!NX.State.getValue("nexus.react.tags",true)}};a.callParent();a.listen({controller:{"#Refresh":{refresh:a.loadStores}},store:{"#Tags":{load:a.reselect}},component:{"nx-proui-tags-feature button[action=search]":{click:a.searchByTag}}})},getDescription:function(a){return a.get("id")},onSelection:function(b,a){if(Ext.isDefined(a)){this.getSettings().loadRecord(a)}},searchByTag:function(){var a=NX.Bookmarks.getBookmark().segments[1],b="#browse/search/custom="+encodeURIComponent('tags="'+a+'"');window.open(b,"_self")}});
