/*
 * Copyright (c) 2008-present Sonatype, Inc.
 *
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/pro/attributions
 * Sonatype and Sonatype Nexus are trademarks of Sonatype, Inc. Apache Maven is a trademark of the Apache Foundation.
 * M2Eclipse is a trademark of the Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Usertoken settings form.
 *
 * @since 3.0
 */
Ext.define('NX.proui.view.usertoken.UserTokenSettings', {
  extend: 'NX.view.SettingsPanel',
  alias: 'widget.nx-proui-usertoken-settings',
  requires: [
    'NX.Conditions',
    'NX.I18n'
  ],

  /**
   * @override
   */
  initComponent: function() {
    Ext.apply(this, {
      settingsForm: [
        {
          xtype: 'nx-settingsform',
          settingsFormSuccessMessage: NX.I18n.get('UserTokenSettings_Update_Success'),
          api: {
            load: 'NX.direct.usertoken_UserToken.read',
            submit: 'NX.direct.usertoken_UserToken.update'
          },
          editableCondition: NX.Conditions.isPermitted('nexus:usertoken-settings:update'),
          editableMarker: NX.I18n.get('UserTokenSettings_Update_Error'),

          items: [
            {
              xtype: 'label',
              html: NX.I18n.get('UserTokenSettings_Html')
            },
            {
              xtype: 'checkbox',
              name: 'enabled',
              fieldLabel: NX.I18n.get('UserTokenSettings_Enable_FieldLabel')
            },
            {
              xtype: 'checkbox',
              name: 'protectContent',
              fieldLabel: NX.I18n.get('UserTokenSettings_Require_FieldLabel'),
              helpText: NX.I18n.get('UserTokenSettings_Require_HelpText')
            }
          ]
        },
        {
          xtype: 'form',
          ui: 'nx-subsection',
          frame: true,
          itemId: 'resetAll',
          title: NX.I18n.get('UserTokenSettings_Reset_Title'),
          hidden: true,

          items: [
            {
              xtype: 'label',
              html: NX.I18n.get('UserTokenSettings_Reset_Html')
            }
          ],

          buttonAlign: 'left',
          buttons: [
            { text: NX.I18n.get('UserTokenSettings_ResetAll_Button'), action: 'resetall', ui: 'nx-primary', iconCls: 'x-fa fa-lock' }
          ]
        }
      ]
    });

    this.callParent();
  }

});
