/*
 * Copyright (c) 2008-present Sonatype, Inc.
 *
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/pro/attributions
 * Sonatype and Sonatype Nexus are trademarks of Sonatype, Inc. Apache Maven is a trademark of the Apache Foundation.
 * M2Eclipse is a trademark of the Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Tag panel.
 *
 * @since 3.14
 */
Ext.define('NX.proui.view.tags.TagPanel', {
  extend: 'Ext.panel.Panel',
  alias: 'widget.nx-proui-tag-panel',
  autoScroll: true,

  requires: [
    'NX.I18n'
  ],

  cls: 'nx-hr',
  ui: 'nx-inset',
  layout: {
    type: 'vbox',
    align: 'stretch'
  },

  title: 'Details',

  loadRecord: function(record) {
    var me = this;

    me.removeAll(true);

    NX.direct.proui_TagList.getTag(record.get('id'), function(response) {
      var items = [],
          tag = response.data;

      if (!response.success) {
        return;
      }

      items.push(me.createTextField(NX.I18n.get('TagPanel_FirstCreated_Label'), new Date(tag.firstCreatedTime).toLocaleString()));

      items.push({xtype:'label', html:'&nbsp;'});

      items.push(me.createTextField(NX.I18n.get('TagPanel_LastUpdated_Label'), new Date(tag.lastUpdatedTime).toLocaleString()));

      items.push({xtype:'label', html:'&nbsp;'});

      items.push(me.createHtmlField(NX.I18n.get('TagPanel_Attributes_Label'), me.toJsonText(tag.attributes)));

      me.add({
        ui: 'nx-subsection',
        frame: true,
        xtype: 'panel',

        layout: {
          type: 'vbox',
          align: 'stretch'
        },
        items: items
      });

      me.fireEvent('recordloaded', me, record);
    });
  },

  /*
   * @private
   * Value will be HTML encoded
   */
  createTextField: function(label, value) {
    return this.createHtmlField(label, Ext.htmlEncode(value));
  },

  /*
   * @private
   * Note callers should ensure any input in value is already HTML encoded.
   */
  createHtmlField: function(label, value) {
    return {
      items: [{
        xtype: 'label',
        html: '<b>' + Ext.htmlEncode(label) + ':</b>'
      }, {
        xtype: 'label',
        html: value
      }],
      xtype: 'panel',
      layout: 'vbox',
      frame: false,
      ui: 'nx-subsection'
    };
  },

  /*
   * @private
   */
  toJsonText: function(obj) {
    return  '<pre>' + Ext.htmlEncode(JSON.stringify(obj, null, 2)) + '</pre>';
  }
});
