/*
 * Copyright (c) 2008-present Sonatype, Inc.
 *
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/pro/attributions
 * Sonatype and Sonatype Nexus are trademarks of Sonatype, Inc. Apache Maven is a trademark of the Apache Foundation.
 * M2Eclipse is a trademark of the Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Tags grid
 *
 * @since 3.14
 */
Ext.define('NX.proui.view.tags.TagList', {
  extend: 'NX.view.drilldown.Master',
  alias: 'widget.nx-proui-tags-list',
  requires: [
    'NX.I18n'
  ],

  stateful: true,
  stateId: 'nx-proui-tags-list',

  tbar: {
    xtype: 'nx-actions'
  },

  /**
   * @override
   */
  initComponent: function() {
    Ext.apply(this, {
      store: 'Tags',

      viewConfig: {
        emptyText: NX.I18n.get('ComponentTags_NoTagsFound_Long'),
        deferEmptyText: false
      },

      columns: [
        {
          text: NX.I18n.get('ComponentTags_TagNameHeader'),
          dataIndex: 'id',
          flex: 2.5,
          renderer: Ext.htmlEncode
        },
        {
          text: NX.I18n.get('ComponentTags_FirstCreatedHeader'),
          dataIndex: 'firstCreatedTime',
          flex: 2.5,
          renderer: function (val) {
            return new Date(val).toLocaleString();
          }
        },
        {
          text: NX.I18n.get('ComponentTags_LastUpdatedHeader'),
          dataIndex: 'lastUpdatedTime',
          flex: 2.5,
          renderer: function (val) {
            return new Date(val).toLocaleString();
          }
        }
      ],

      plugins: [
        {ptype: 'gridfilterbox', emptyText: NX.I18n.get('Tags_EmptyText')}
      ]
    });

    this.callParent();
  }

});
