/*
 * Copyright (c) 2008-present Sonatype, Inc.
 *
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/pro/attributions
 * Sonatype and Sonatype Nexus are trademarks of Sonatype, Inc. Apache Maven is a trademark of the Apache Foundation.
 * M2Eclipse is a trademark of the Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * System Information panel.
 *
 * @since 3.4
 */
Ext.define('NX.proui.view.database.DatabaseQuorumResetConfirm', {
  extend: 'NX.view.SettingsPanel',
  alias: 'widget.nx-proui-database-quorum-reset',
  requires: [
    'NX.I18n'
  ],

  /**
   * @override
   */
  initComponent: function() {
    var me = this;
    Ext.apply(me, {
      settingsForm: {
        xtype: 'nx-settingsform',
        items: [
          {
            xtype: 'label',
            html: '<h3>Resetting the Database Write Quorum</h3>' +
            '<p>Resetting the database write quorum is not meant to fix all problems related to Nexus clustering. ' +
            'However it can be used if you would like to reduce your cluster down to a single node and rebuild your ' +
            'cluster.</p>' +
            '<p>It is important to understand the implications of resetting the write quorum. In doing so, you will ' +
            'move from having a "cluster" to only having one working node. If that is your intention, then we ' +
            'suggest that you first attempt to shut down any other running Nexus nodes.</p>' +
            '<p>To recreate your cluster after resetting the write quorum, you will need to reattach nodes to the ' +
            'cluster. The new nodes that join your cluster, after resetting the write quorum, may need to replicate ' +
            'all of the Nexus databases. This may consume considerable time and resources.</p>'
          }
        ],
        buttonAlign: 'left',
        buttons: [
          {
            xtype: 'button',
            text: NX.I18n.get('DatabaseQuorumReset_ResetButton'),
            iconCls: 'x-fa fa-download',
            action: 'resetQuorum'
          }
        ]
      }
    });
    me.callParent();
  }

});
