/*
 * Copyright (c) 2008-present Sonatype, Inc.
 *
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/pro/attributions
 * Sonatype and Sonatype Nexus are trademarks of Sonatype, Inc. Apache Maven is a trademark of the Apache Foundation.
 * M2Eclipse is a trademark of the Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Application strings
 *
 * @since 3.0
 */
Ext.define('NX.proui.app.PluginStrings', {
  '@aggregate_priority': 90,

  singleton: true,
  requires: [
    'NX.I18n'
  ],

  /*
   * Note: Symbols follow the following naming convention:
   * <Class>_<Name>_<Component or Attribute>
   */

  keys: {
    // Admin -> Security -> Atlassian Crowd
    Crowd_Text: 'Atlassian Crowd',
    Crowd_Description: 'Manage Atlassian Crowd configuration',
    Crowd_CrowdSettings_Update_Error: 'You do not have permission to configure Atlassian Crowd',
    Crowd_CrowdSettings_Update_Success: 'Atlassian Crowd settings $action',
    Crowd_CrowdSettings_Html: '<p>Application can be configured to use <a href="https://www.atlassian.com/software/crowd" target="_blank" rel="noopener">Atlassian Crowd</a> for user database and authentication.</p>',
    Crowd_CrowdSettings_Enable_FieldLabel: 'Enable Crowd',
    Crowd_CrowdSettings_Activate_FieldLabel: 'Enable Crowd Realm for authentication',
    Crowd_CrowdSettings_Activate_HelpText: 'To control ordering, go to the <a href="#admin/security/realms">Realms</a> page.',
    Crowd_CrowdSettings_URL_FieldLabel: 'Crowd server URL',
    Crowd_CrowdSettings_URL_HelpText: 'For example: http://localhost:8095/crowd',
    Crowd_CrowdSettings_Name_FieldLabel: 'Crowd application name',
    Crowd_CrowdSettings_Password_FieldLabel: 'Crowd application password',
    Crowd_CrowdSettings_Request_FieldLabel: 'Connection timeout',
    Crowd_CrowdSettings_Request_HelpText: 'Seconds to wait for activity before stopping and retrying the connection. Leave blank to use the globally defined HTTP timeout.',
    Crowd_CrowdSettings_VerifyConnection_Text: 'Verify connection',
    Crowd_CrowdSettings_Verified_Success: 'Connection to Crowd server verified: {0}',
    Crowd_CrowdSettings_ClearCache_Text: 'Clear cache',
    Crowd_CrowdSettings_ClearCache_Success: 'Crowd cache has been cleared',

    // Admin -> Security -> User Token
    UserToken_Text: 'User Token',
    UserToken_Description: 'Manage user token configuration',
    UserTokenSettings_Update_Error: 'You do not have permission to configure user token',
    UserTokenSettings_Update_Success: 'User Token settings $action',
    UserTokenSettings_Html: '<p>The user token feature allows users to authenticate securely ' +
    'without typical user credentials such as those used by LDAP or Crowd.</p>' +
    '<p>User tokens generated for this server are only valid for use on this server. Once enabled, users can access ' +
    'their user token from <a href="#user/usertoken">user mode</a>.</p>',
    UserTokenSettings_Enable_FieldLabel: 'Enable user tokens',
    UserTokenSettings_Require_FieldLabel: 'Require user tokens for repository authentication',
    UserTokenSettings_Require_HelpText: 'This does not affect UI access',
    UserTokenSettings_Reset_Title: 'Reset user tokens',
    UserTokenSettings_Reset_Html: '<p>Reset will invalidate <b>ALL</b> existing user tokens and force new tokens to be created the next time they are accessed.</p>',
    UserTokenSettings_ResetAll_Button: 'Reset all user tokens',
    UserToken_Authentication_Validation: '{0} user tokens requires validation of your credentials.',
    UserToken_ResetAll_Success: 'All user tokens have been reset',
    UserToken_Reset_Success: 'Your user token has been reset',
    UserToken_ResetById_Message: 'User token of {0} has been reset',

    // Admin -> Security -> Users -> User Token -> Reset Token
    UserToken_UserTokenUser_Title: 'User Token',
    UserToken_UserTokenUser_ResetToken_Title: 'Reset user token',
    UserToken_UserTokenUser_ResetToken_Html: '<p>Resetting a user’s token will invalidate their current token and force a new token to be created the next time it is accessed by the user.</p>',
    UserToken_UserTokenUser_ResetToken_Button: 'Reset user token',

    // Healthcheck results
    HealthCheckInfo_Security_Alerts_Label: 'Security',
    HealthCheckInfo_License_Threat_Label: 'License ',
    HealthCheckInfo_Tooltip: 'License and security data is only available with a paid license.',
    HealthCheckInfo_LoggedInOnly_Tooltip: 'The license and security data is only available once you have logged in.',
    HealthCheckInfo_NoPermission_Tooltip: 'You do not have permission to view the license and security data.',

    FirewallRepositoryColumn_Header: 'Firewall Report',
    FirewallRepositoryColumn_Loading: 'Loading&hellip;',
    FirewallRepositoryColumn_NoViolations: 'No violations',

    DatabaseQuorumReset_Title: 'Cluster Reset',
    DatabaseQuorumResetConfirm_Resetting: 'Resetting Cluster Size',
    DatabaseQuorumReset_Description: 'Take your cluster down to a single node',
    DatabaseQuorumReset_ResetButton: 'Reset Database Quorum',
    DatabaseQuorumResetConfirm_Title: 'Confirm Cluster Reset',
    DatabaseQuorumResetConfirm_HelpText: 'Have you ensured that other nodes in the cluster are shut down? Resetting the quorum can result in corrupt data if other nodes are still online.',
    DatabaseQuorumResetConfirm_Fail: 'Failed to reset database cluster quorum setting!',
    DatabaseQuorumResetConfirm_GetLocalNode_Fail: 'Unable to detect which node you are currently connected to',
    DatabaseQuorumResetConfirm_LocalNodeNotKnown: 'Cannot reset database cluster quorum setting, the current node is unidentified',
    DatabaseQuorumResetConfirm_Success: 'The database cluster write quorum was reset to one node',
    DatabaseQuorumResetConfirm_Yes: 'Reset Quorum',
    DatabaseQuorumResetConfirm_No: '@Button_Cancel',

    // Tags
    ComponentTags_TagTitle: 'Component Tags',
    ComponentTags_NoTagsFound: 'No tags found',
    ComponentTags_NoTagsFound_Long: '<div class="summary">There are no tags created yet<br>' +
        '<span style="font-weight: lighter; font-size: small;">or you don\'t have permission to browse them</span></div>' +
        '<div class="panel nx-subsection"><h3 class="title"><span class="icon"></span>What is a tag?</h3>' +
        '<p>Tagging is a feature available in Nexus Repository Manager Pro that provides the ability to mark a set ' +
        'of components with a tag so they can be logically associated to each other. The usage of the tags is up to ' +
        'you but the most common scenarios would be a CI build ID for a project (e.g. project-abc-build-142) or a ' +
        'higher level release train when you are coordinating multiple projects together as a single unit (e.g. ' +
        'release-train-13). Tagging is used extensively by the ' +
        '<a href="http://links.sonatype.com/products/nxrm3/docs/staging" target="_blank" rel="noopener noreferrer">staging</a> feature. For more information, check ' +
        '<a href="http://links.sonatype.com/products/nxrm3/docs/component-tag" target="_blank" rel="noopener noreferrer">the documentation</a>.</p></div>',
    ComponentTags_ClickForDetails: 'Click row to view details in a new window',
    ComponentTags_TagNameHeader: 'Tag Name',
    ComponentTags_FirstCreatedHeader: 'First Created Time',
    ComponentTags_LastUpdatedHeader: 'Last Updated Time',

    Tags_Description: 'View created tags',
    Tags_Title: 'Tags',
    Tags_EmptyText: 'No tags found.',
    TagFeature_FindTaggedComponents_Button: 'Find Tagged Components',
    TagPanel_Attributes_Label: 'Attributes',
    TagPanel_FirstCreated_Label: 'First Created Time',
    TagPanel_LastUpdated_Label: 'Last Updated Time',

    // Group Deployment
    GroupDeployment_Docker_Help: '<em>Deploying through a group repository has different behaviors than deploying directly to a hosted repository. ' +
        'Read our <a href="http://links.sonatype.com/products/nxrm3/docs/pushing-images" target="_blank">documentation</a>' +
        ' for more details.</em>',

    // Pro-Starter Alert and Tooltip Content
    Starter_Edition: 'PRO-STARTER',
    Total_Components_Tooltip: 'Sonatype Nexus Repository\'s Pro Starter version only supports up to {} components. Upgrade to Pro with a PostgreSQL database for unlimited component support.',
    Requests_Per_Day_Tooltip: 'Sonatype Nexus Repository\'s Pro Starter version only supports up to {} requests per day to repository endpoints for all repositories. Upgrade to Pro with a PostgreSQL database for unlimited requests.',
    Exceeding_Threshold_Requests_Per_Day_Prefix: 'Users can not currently upload to this repository. This repository has hit the maximum of {} peak requests in the past 30 days. ',
    Exceeding_Threshold_Requests_Per_Day_Mid: ' and consider ',
    Exceeding_Threshold_Total_Components_Prefix: 'Users can not currently upload to this repository. This repository contains the maximum of {} components. ',
    Exceeding_Threshold_Total_Components_Mid: ' and consider removing unused components or ',
    Approaching_Threshold_Requests_Per_Day_Prefix: 'This repository is approaching the maximum of {} peak requests in the past 30 days. Users will not be able to upload to this repository after reaching this limit. ',
    Approaching_Threshold_Requests_Per_Day_Mid: ' and consider ',
    Approaching_Threshold_Total_Components_Prefix: 'This repository is approaching the maximum of {} components. Users will not be able to upload to this repository after reaching this limit. ',
    Approaching_Threshold_Total_Components_Mid: ' and consider removing unused components or ',
    Suffix: ' for unlimited usage.',
  }
}, function(obj) {
  NX.I18n.register(obj);
});
