/*
 * Copyright (c) 2008-present Sonatype, Inc.
 *
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/pro/attributions
 * Sonatype and Sonatype Nexus are trademarks of Sonatype, Inc. Apache Maven is a trademark of the Apache Foundation.
 * M2Eclipse is a trademark of the Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * ProUi plugin configuration.
 *
 * @since 3.0
 */
Ext.define('NX.proui.app.PluginConfig', {
  '@aggregate_priority': 100,

  requires: [
    'NX.State',
    'NX.proui.app.PluginStrings'
  ],

  controllers: [
    { id: 'NX.proui.controller.ComponentTags',
      active: function () {
        return NX.app.Application.bundleActive('com.sonatype.nexus.plugins.nexus-tags-plugin');
      }
    },
    { id: 'NX.proui.controller.HealthCheckRepositoryDetail',
      active: function () {
        return NX.app.Application.bundleActive('com.sonatype.nexus.plugins.nexus-clm-plugin');
      }
    },
    { id: 'NX.proui.controller.HealthCheckAssetDetail',
      active: function () {
        return NX.app.Application.bundleActive('com.sonatype.nexus.plugins.nexus-clm-plugin');
      }
    },
    { id: 'NX.proui.controller.HealthCheckInfo',
      active: function () {
        return NX.app.Application.bundleActive('com.sonatype.nexus.plugins.nexus-clm-plugin');
      }
    },
    { id: 'NX.proui.controller.UserToken',
      active: function () {
        return NX.State.getValue('usertoken', {})['licenseValid']
            && NX.app.Application.bundleActive('com.sonatype.nexus.plugins.nexus-usertoken-plugin');
      }
    },
    { id: 'NX.proui.controller.DatabaseQuorumReset',
      active: function () {
        return true;
      }
    },
    {
      id: 'NX.proui.controller.Tags',
      active: function() {
        return NX.app.Application.bundleActive('com.sonatype.nexus.plugins.nexus-tags-plugin');
      }
    }
  ]
});
