Ext.define("NX.azureblobstore.app.PluginStrings",{"@aggregate_priority":90,singleton:true,requires:["NX.I18n"],keys:{AzureBlobstore_AccountName_FieldLabel:"Account Name",AzureBlobstore_AccountName_HelpText:"The name of the Azure storage account.",AzureBlobstore_ContainerName_FieldLabel:"Container Name",AzureBlobstore_ContainerName_HelpText:"The name of a container to be used for storage.  The container will be created if it does not already exist.",AzureBlobstore_Authentication_Title:"Authentication",AzureBlobstore_AuthenticationMethod_Title:"Authentication Method",AzureBlobstore_ManagedIdentity_FieldLabel:"Managed Identity (System)",AzureBlobstore_AccountKey_FieldLabel:"Account Key",AzureBlobstore_AccountKey_HelpText:"Account key found under Access keys for the storage account.",}},function(a){NX.I18n.register(a)});Ext.define("NX.azureblobstore.app.PluginConfig",{"@aggregate_priority":100,requires:["NX.azureblobstore.app.PluginStrings"],controllers:[{id:"NX.azureblobstore.controller.AzureBlobstore",active:true}]});Ext.define("NX.azureblobstore.view.BlobstoreSettings",{extend:"NX.view.SettingsPanel",alias:"widget.nx-blobstore-settings-azure",requires:["Ext.data.Store","NX.I18n"],settingsForm:[{xtype:"textfield",name:"property_accountName",fieldLabel:NX.I18n.get("AzureBlobstore_AccountName_FieldLabel"),helpText:NX.I18n.get("AzureBlobstore_AccountName_HelpText"),allowBlank:false},{xtype:"textfield",name:"property_containerName",fieldLabel:NX.I18n.get("AzureBlobstore_ContainerName_FieldLabel"),helpText:NX.I18n.get("AzureBlobstore_ContainerName_HelpText"),allowBlank:false,regex:/^[a-z0-9][a-z0-9-]{2,62}$/,regexText:"Container names can contain only lowercase letters, numbers, and the dash (-) character, and must be 3-63 characters long."},{xtype:"nx-optionalfieldset",title:NX.I18n.get("AzureBlobstore_Authentication_Title"),checkboxToggle:true,checkboxName:"authEnabled",collapsed:false,items:[{xtype:"fieldcontainer",fieldLabel:NX.I18n.get("AzureBlobstore_AuthenticationMethod_Title"),defaultType:"radiofield",layout:"vbox",items:[{boxLabel:NX.I18n.get("AzureBlobstore_ManagedIdentity_FieldLabel"),name:"property_authenticationMethod",itemId:"managedIdentityOption",inputValue:"MANAGEDIDENTITY",listeners:{change:function(b){var a=b.up("form").down("#accountKey");if(b.getValue()){a.setDisabled(true)}}}},{boxLabel:NX.I18n.get("AzureBlobstore_AccountKey_FieldLabel"),name:"property_authenticationMethod",itemId:"accountKeyOption",inputValue:"ACCOUNTKEY",listeners:{change:function(b){var a=b.up("form").down("#accountKey");if(b.getValue()){a.setDisabled(false)}}}},{xtype:"textfield",inputType:"password",name:"property_accountKey",itemId:"accountKey",helpText:NX.I18n.get("AzureBlobstore_AccountKey_HelpText"),allowBlank:true,disabledOnCollapse:true}]}],listeners:{afterrender:function(a){var b=a.up("form");if(!b.form.getValues()["property_authenticationMethod"]){b.down("#managedIdentityOption").setValue(true)}}}}],exportProperties:function(a){var b={};Ext.Object.each(a,function(c,d){if(c.startsWith("property_")){b[c.replace("property_","")]=String(d)}});return b}});Ext.define("NX.azureblobstore.controller.AzureBlobstore",{extend:"NX.wizard.Controller",views:["NX.azureblobstore.view.BlobstoreSettings"]});
