/*
 * Copyright (c) 2008-present Sonatype, Inc.
 *
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/pro/attributions
 * Sonatype and Sonatype Nexus are trademarks of Sonatype, Inc. Apache Maven is a trademark of the Apache Foundation.
 * M2Eclipse is a trademark of the Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * @since 3.17
 */
Ext.define('NX.azureblobstore.app.PluginStrings', {
  '@aggregate_priority': 90,

  singleton: true,
  requires: [
    'NX.I18n'
  ],

  keys: {
    AzureBlobstore_AccountName_FieldLabel: 'Account Name',
    AzureBlobstore_AccountName_HelpText: 'The name of the Azure storage account.',

    AzureBlobstore_ContainerName_FieldLabel: 'Container Name',
    AzureBlobstore_ContainerName_HelpText: 'The name of a container to be used for storage.  The container will be created if it does not already exist.',

    AzureBlobstore_Authentication_Title: 'Authentication',
    AzureBlobstore_AuthenticationMethod_Title: 'Authentication Method',

    AzureBlobstore_ManagedIdentity_FieldLabel: 'Managed Identity (System)',

    AzureBlobstore_AccountKey_FieldLabel: 'Account Key',
    AzureBlobstore_AccountKey_HelpText: 'Account key found under Access keys for the storage account.',
  }

}, function(obj) {
  NX.I18n.register(obj);
});

/*
 * Copyright (c) 2008-present Sonatype, Inc.
 *
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/pro/attributions
 * Sonatype and Sonatype Nexus are trademarks of Sonatype, Inc. Apache Maven is a trademark of the Apache Foundation.
 * M2Eclipse is a trademark of the Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Azure blob store plugin configuration
 *
 */
Ext.define('NX.azureblobstore.app.PluginConfig', {
  '@aggregate_priority': 100,

  requires: [
    'NX.azureblobstore.app.PluginStrings'
  ],

  controllers: [
    {
      id: 'NX.azureblobstore.controller.AzureBlobstore',
      active: true
    }
  ]
});

/*
 * Copyright (c) 2008-present Sonatype, Inc.
 *
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/pro/attributions
 * Sonatype and Sonatype Nexus are trademarks of Sonatype, Inc. Apache Maven is a trademark of the Apache Foundation.
 * M2Eclipse is a trademark of the Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Azure Blobstore custom "Settings" panel.
 *
 */
Ext.define('NX.azureblobstore.view.BlobstoreSettings', {
  extend: 'NX.view.SettingsPanel',
  alias: 'widget.nx-blobstore-settings-azure',
  requires: [
    'Ext.data.Store',
    'NX.I18n'
  ],

  settingsForm: [
    {
      xtype:'textfield',
      name: 'property_accountName',
      fieldLabel: NX.I18n.get('AzureBlobstore_AccountName_FieldLabel'),
      helpText: NX.I18n.get('AzureBlobstore_AccountName_HelpText'),
      allowBlank: false
    },
    {
      xtype:'textfield',
      name: 'property_containerName',
      fieldLabel: NX.I18n.get('AzureBlobstore_ContainerName_FieldLabel'),
      helpText: NX.I18n.get('AzureBlobstore_ContainerName_HelpText'),
      allowBlank: false,
      regex: /^[a-z0-9][a-z0-9-]{2,62}$/,
      regexText: 'Container names can contain only lowercase letters, numbers, and the dash (-) character, and must be 3-63 characters long.'
    },
    {
      xtype: 'nx-optionalfieldset',
      title: NX.I18n.get('AzureBlobstore_Authentication_Title'),
      checkboxToggle: true,
      checkboxName: 'authEnabled',
      collapsed: false,
      items: [
        {
          xtype: 'fieldcontainer',
          fieldLabel: NX.I18n.get('AzureBlobstore_AuthenticationMethod_Title'),
          defaultType: 'radiofield',
          layout: 'vbox',
          items: [
            {
              boxLabel: NX.I18n.get('AzureBlobstore_ManagedIdentity_FieldLabel'),
              name: 'property_authenticationMethod',
              itemId: 'managedIdentityOption',
              inputValue: 'MANAGEDIDENTITY',
              listeners: {
                change: function(radio) {
                  var accountKey = radio.up('form').down('#accountKey');
                  if (radio.getValue()) {
                    accountKey.setDisabled(true);
                  }
                }
              }
            },
            {
              boxLabel: NX.I18n.get('AzureBlobstore_AccountKey_FieldLabel'),
              name: 'property_authenticationMethod',
              itemId: 'accountKeyOption',
              inputValue: 'ACCOUNTKEY',
              listeners: {
                change: function(radio) {
                  var accountKey = radio.up('form').down('#accountKey');
                  if (radio.getValue()) {
                    accountKey.setDisabled(false);
                  }
                }
              }
            },
            {
              xtype:'textfield',
              inputType: 'password',
              name: 'property_accountKey',
              itemId: 'accountKey',
              helpText: NX.I18n.get('AzureBlobstore_AccountKey_HelpText'),
              allowBlank: true,
              disabledOnCollapse: true
            }
          ]
        }
      ],
      listeners: {
        afterrender: function(container) {
          var form = container.up('form');
          if (!form.form.getValues()['property_authenticationMethod']) {
            form.down('#managedIdentityOption').setValue(true);
          }
        }
      }
    }
  ],

  exportProperties: function(values) {
    var properties = {};
    Ext.Object.each(values, function(key, value) {
      if (key.startsWith('property_')) {
        properties[key.replace('property_', '')] = String(value);
      }
    });
    return properties;
  }
  
});

/*
 * Copyright (c) 2008-present Sonatype, Inc.
 *
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/pro/attributions
 * Sonatype and Sonatype Nexus are trademarks of Sonatype, Inc. Apache Maven is a trademark of the Apache Foundation.
 * M2Eclipse is a trademark of the Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * @since 3.17
 */
Ext.define('NX.azureblobstore.controller.AzureBlobstore', {
  extend: 'NX.wizard.Controller',

  views: [
    'NX.azureblobstore.view.BlobstoreSettings'
  ]
});

