/*
 * Copyright (c) 2008-present Sonatype, Inc.
 *
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/pro/attributions
 * Sonatype and Sonatype Nexus are trademarks of Sonatype, Inc. Apache Maven is a trademark of the Apache Foundation.
 * M2Eclipse is a trademark of the Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * @since 3.17
 */
Ext.define('NX.azureblobstore.app.PluginStrings', {
  '@aggregate_priority': 90,

  singleton: true,
  requires: [
    'NX.I18n'
  ],

  keys: {
    AzureBlobstore_AccountName_FieldLabel: 'Account Name',
    AzureBlobstore_AccountName_HelpText: 'The name of the Azure storage account.',

    AzureBlobstore_ContainerName_FieldLabel: 'Container Name',
    AzureBlobstore_ContainerName_HelpText: 'The name of a container to be used for storage.  The container will be created if it does not already exist.',

    AzureBlobstore_Authentication_Title: 'Authentication',
    AzureBlobstore_AuthenticationMethod_Title: 'Authentication Method',

    AzureBlobstore_ManagedIdentity_FieldLabel: 'Managed Identity (System)',

    AzureBlobstore_AccountKey_FieldLabel: 'Account Key',
    AzureBlobstore_AccountKey_HelpText: 'Account key found under Access keys for the storage account.',
  }

}, function(obj) {
  NX.I18n.register(obj);
});
