/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Open Source Version is distributed with Sencha Ext JS pursuant to a FLOSS Exception agreed upon
 * between Sonatype, Inc. and Sencha Inc. Sencha Ext JS is licensed under GPL v3 and cannot be redistributed as part of a
 * closed source work.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Component details panel.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.view.component.ComponentDetails', {
  // FIXME: change to container
  extend: 'Ext.panel.Panel',
  alias: 'widget.nx-coreui-component-details',

  cls: 'nx-coreui-component-details',

  requires: [
    'NX.ext.button.Button'
  ],

  /**
   * Currently shown component model.
   */
  componentModel: undefined,

  layout: {
    type: 'hbox',
    align: 'stretch'
  },

  /**
   * @override
   */
  initComponent: function() {
    Ext.apply(this, {
      dockedItems: {
        xtype: 'nx-actions',
        dock: 'bottom',
        items: [
          {
            xtype: 'nx-button',
            text: NX.I18n.get('ComponentDetails_View_Vulnerabilities_Button'),
            iconCls: 'x-fa fa-bug',
            action: 'viewVulnerabilities',
            hidden: true
          },
          {
            xtype: 'nx-button',
            text: ''+NX.I18n.get('ComponentDetails_Delete_Button'),
            iconCls: 'x-fa fa-trash',
            action: 'deleteComponent',
            hidden: true
          },
          {
            xtype: 'nx-button',
            text: NX.I18n.get('ComponentDetails_Browse_Snapshots_Button'),
            iconCls: 'x-fa fa-database',
            action: 'browseComponent',
            hidden: true
          },
          {
            xtype: 'nx-button',
            text: NX.I18n.get('ComponentDetails_Analyze_Button'),
            iconCls: 'x-fa fa-cog',
            action: 'analyzeApplication'
          },
          {
            xtype: 'nx-coreui-component-analyze-window',
            hidden: false
          }
        ]
      },

      items: [
        {xtype: 'nx-info', itemId: 'repositoryInfo'},
        {xtype: 'nx-info', itemId: 'componentInfo'},
        {xtype: 'nx-info', itemId: 'extraInfo'}
      ]
    });

    this.callParent();
  },

  /**
   * Sets component.
   *
   * @public
   * @param {NX.coreui.model.Component} componentModel
   */
  setComponentModel: function(componentModel) {
    var me = this;

    me.componentModel = componentModel;
    me.fireEvent('updated', me, me.componentModel);
  }
});
