/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Open Source Version is distributed with Sencha Ext JS pursuant to a FLOSS Exception agreed upon
 * between Sonatype, Inc. and Sencha Inc. Sencha Ext JS is licensed under GPL v3 and cannot be redistributed as part of a
 * closed source work.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext*/

/**
 * Quick search box
 *
 * @since 3.0
 */
Ext.define('NX.view.header.QuickSearch', {
  extend: 'NX.ext.SearchBox',
  alias: 'widget.nx-header-quicksearch',
  requires: [
    'NX.I18n',
    'NX.ext.plugin.SearchBoxTip'
  ],

  plugins: [
    {
      ptype: 'searchboxtip',
      message: NX.I18n.get('SearchBoxTip_ExactMatch') + '<br>' + NX.I18n.get('SearchBoxTip_Wildcard')
    }
  ],

  /**
   * @override
   */
  initComponent: function() {
    Ext.apply(this, {
      itemId: 'quicksearch',
      cls: 'nx-quicksearch',
      iconClass: 'fa-search',
      width: 220,
      emptyText: NX.I18n.get('Header_QuickSearch_Empty'),
      ariaRole: 'search',
      ariaLabel: NX.I18n.get('Header_QuickSearch_Tooltip')
    });

    this.callParent();
  },

  onValueChange: function() {
    // NO-OP to Prevent Auto-Search
  },

  triggerSearch: function() {
    this.fireEvent('search', this, this.getValue());
  }
});
