/*
 * Copyright (c) 2008-present Sonatype, Inc.
 *
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/pro/attributions
 * Sonatype and Sonatype Nexus are trademarks of Sonatype, Inc. Apache Maven is a trademark of the Apache Foundation.
 * M2Eclipse is a trademark of the Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * PyPI plugin configuration.
 *
 * @since 3.15
 */
Ext.define('NX.pypi.app.PluginConfig', {
  '@aggregate_priority': 100,

  controllers: [
    {
      id: 'NX.pypi.controller.PyPiDependencySnippetController',
      active: true
    }
  ]
});

/*
 * Copyright (c) 2008-present Sonatype, Inc.
 *
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/pro/attributions
 * Sonatype and Sonatype Nexus are trademarks of Sonatype, Inc. Apache Maven is a trademark of the Apache Foundation.
 * M2Eclipse is a trademark of the Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * PyPI controller.
 *
 * @since 3.15
 */
Ext.define('NX.pypi.controller.PyPiDependencySnippetController', {
  extend: 'NX.app.Controller',

  /**
   * @override
   */
  init: function() {
    NX.getApplication().getDependencySnippetController()
        .addDependencySnippetGenerator('pypi', this.snippetGenerator);
  },

  snippetGenerator: function(componentModel, assetModel) {
    var name = componentModel.get('name'),
        version = componentModel.get('version');

    return [
      {
        displayName: 'pip',
        snippetText: 'pip install ' + name + '==' + version
      }, {
        displayName: 'easy_install',
        snippetText: 'easy_install ' + name + '==' + version
      }, {
        displayName: 'pipenv',
        snippetText: 'pipenv install ' + name + '==' + version
      }, {
        displayName: 'requirements.txt',
        snippetText: name + ' == ' + version
      }
    ];
  }
});

