/*
 * Copyright (c) 2008-present Sonatype, Inc.
 *
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/pro/attributions
 * Sonatype and Sonatype Nexus are trademarks of Sonatype, Inc. Apache Maven is a trademark of the Apache Foundation.
 * M2Eclipse is a trademark of the Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Analytics controller.
 *
 * @since 3.20
 */
Ext.define('NX.analytics.controller.Analytics', {
  extend: 'NX.app.Controller',
  requires: [
    'NX.util.Url',
    'Ext.Ajax'
  ],

  /**
   * @override
   */
  init: function() {
    var me = this;

    me.listen({
      component: {
        'nx-info-dependency-snippet-panel button[action=copySnippet]': {
          click: me.copySnippetClicked
        },
        'nx-info-dependency-snippet-panel': {
          snippetDisplayed: me.snippetDisplayed
        }
      }
    });
  },

  snippetDisplayed: function(snippet) {
    this.currentFormat = snippet.format;
    this.currentSnippet = snippet.snippet;
  },

  copySnippetClicked: function() {
    var me = this,
        url = NX.util.Url.urlOf(
            'service/rest/dependency_snippets?format=' + me.currentFormat + '&snippet=' + me.currentSnippet);
    Ext.Ajax.request({
      url: url,
      method: 'POST',
      scope: me,
      suppressStatus: true
    });
  }
});
