/*
 * Copyright (c) 2008-present Sonatype, Inc.
 *
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/pro/attributions
 * Sonatype and Sonatype Nexus are trademarks of Sonatype, Inc. Apache Maven is a trademark of the Apache Foundation.
 * M2Eclipse is a trademark of the Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * SAML Application strings
 *
 * @since 3.22
 */
Ext.define('NX.saml.app.PluginStrings', {
  '@aggregate_priority': 90,

  singleton: true,
  requires: [
    'NX.I18n'
  ],

  keys: {
    SAML_SignIn_SSO: 'Sign In with SSO',
    SAML_SignIn_Local: 'Sign In without SSO'
  }
}, function(obj) {
  NX.I18n.register(obj);
});
