/*
 * Copyright (c) 2008-present Sonatype, Inc.
 *
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/pro/attributions
 * Sonatype and Sonatype Nexus are trademarks of Sonatype, Inc. Apache Maven is a trademark of the Apache Foundation.
 * M2Eclipse is a trademark of the Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * SAML plugin configuration.
 *
 * @since 3.22
 */
Ext.define('NX.saml.app.PluginConfig', {
  '@aggregate_priority': 100,

  requires: [
    'NX.saml.app.PluginStrings'
  ],

  controllers: [
    {
      id: 'NX.saml.controller.SamlAuth',
      active: function() {
        return NX.State.getValue("samlEnabled", false);
      }
    }
  ]
});
