/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.goodies.common;

import com.google.common.base.Preconditions;
import org.slf4j.Logger;
import org.sonatype.goodies.common.Loggers;
import org.sonatype.goodies.common.Properties2;
import org.sonatype.gossip.Level;

public final class UnhandledThrowable {
    private static final Logger log = Loggers.getLogger(UnhandledThrowable.class);
    private static final Level level = UnhandledThrowable.getFailureLevel();

    private UnhandledThrowable() {
    }

    private static Level getFailureLevel() {
        Level level = Level.TRACE;
        String value = Properties2.getSystemProperty(UnhandledThrowable.class, "failureLevel", level);
        try {
            return Level.valueOf((String)value.toUpperCase());
        }
        catch (Throwable e) {
            log.error("Invalid level: {}", (Object)value, (Object)e);
            return level;
        }
    }

    public static void onFailure(Throwable cause) {
        Preconditions.checkNotNull((Object)cause);
        if (level.isEnabled(log)) {
            level.log(log, cause.toString(), cause);
        }
    }
}

