/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.goodies.common;

import com.google.common.base.Preconditions;
import java.util.Collection;

public final class Throwables2 {
    public static String explain(Throwable throwable) {
        Preconditions.checkNotNull((Object)throwable);
        StringBuilder buff = new StringBuilder();
        Throwables2.explain(buff, throwable);
        Throwable cause = throwable;
        while ((cause = cause.getCause()) != null) {
            buff.append(", caused by: ");
            Throwables2.explain(buff, cause);
        }
        return buff.toString();
    }

    private static void explain(StringBuilder buff, Throwable throwable) {
        Throwable cause;
        buff.append(throwable.getClass().getName());
        String msg = throwable.getMessage();
        if (!(msg == null || (cause = throwable.getCause()) != null && msg.equals(cause.toString()))) {
            buff.append(": ").append(msg);
        }
    }

    public static <T extends Throwable> T composite(T root, Throwable ... suppressed) throws T {
        Preconditions.checkNotNull((Object)suppressed);
        for (Throwable t : suppressed) {
            root.addSuppressed(t);
        }
        throw root;
    }

    public static <T extends Throwable> T composite(T root, Collection<? extends Throwable> suppressed) throws T {
        Preconditions.checkNotNull(suppressed);
        for (Throwable throwable : suppressed) {
            root.addSuppressed(throwable);
        }
        throw root;
    }
}

