/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.goodies.common;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.beans.PropertyEditorSupport;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.sonatype.goodies.common.Loggers;

public class SystemProperty {
    private static final Logger log = Loggers.getLogger(SystemProperty.class);
    private final String name;

    public SystemProperty(String name) {
        this.name = (String)Preconditions.checkNotNull((Object)name);
    }

    public SystemProperty(Class<?> type, String suffix) {
        this(((Class)Preconditions.checkNotNull(type, (Object)"type")).getName() + "." + (String)Preconditions.checkNotNull((Object)suffix, (Object)"suffix"));
    }

    @VisibleForTesting
    Properties properties() {
        return System.getProperties();
    }

    public String name() {
        return this.name;
    }

    public void set(@Nullable Object value) {
        String str = String.valueOf(value);
        this.properties().setProperty(this.name, str);
        log.trace("Set {}={}", (Object)this.name, (Object)str);
    }

    public boolean isSet() {
        return this.get() != null;
    }

    @Nullable
    public String get() {
        return this.properties().getProperty(this.name);
    }

    public String get(String defaultValue) {
        String value = this.get();
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    @Nullable
    public <T> T get(Class<T> type) {
        String value;
        Preconditions.checkNotNull(type);
        PropertyEditor editor = PropertyEditorManager.findEditor(type);
        if (editor == null) {
            if (type == Boolean.class) {
                editor = new BooleanPropertyEditor();
            } else if (type == Integer.class) {
                editor = new IntegerPropertyEditor();
            } else {
                throw new RuntimeException("No property-editor for type: " + type.getName());
            }
        }
        if ((value = this.get()) == null) {
            return null;
        }
        editor.setAsText(value);
        return (T)editor.getValue();
    }

    public <T> T get(Class<T> type, T defaultValue) {
        T value = this.get(type);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    public void remove() {
        this.properties().remove(this.name);
        log.trace("Remove: {}", (Object)this.name);
    }

    public List<String> asList() {
        String value = this.get();
        if (value == null) {
            return Collections.emptyList();
        }
        String[] items = value.split(",");
        ArrayList result = Lists.newArrayListWithCapacity((int)items.length);
        for (String item : items) {
            result.add(item.trim());
        }
        return result;
    }

    public String toString() {
        return this.name + "=" + this.get();
    }

    private static class IntegerPropertyEditor
    extends TextPropertyEditorSupport {
        private IntegerPropertyEditor() {
        }

        @Override
        public Object getValue() {
            return Integer.valueOf(this.getAsText());
        }
    }

    private static class BooleanPropertyEditor
    extends TextPropertyEditorSupport {
        private BooleanPropertyEditor() {
        }

        @Override
        public Object getValue() {
            return Boolean.valueOf(this.getAsText());
        }
    }

    private static class TextPropertyEditorSupport
    extends PropertyEditorSupport {
        private TextPropertyEditorSupport() {
        }

        @Override
        public void setAsText(String text) {
            super.setValue(text);
        }
    }
}

