/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.goodies.common;

import com.google.common.base.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Loggers {
    private static final String GUICE_ENHANCED = "$$EnhancerByGuice$$";

    private static boolean isEnhancedSubclass(Class<?> type) {
        return type.getName().contains(GUICE_ENHANCED);
    }

    public static Logger getLogger(Class<?> type) {
        Preconditions.checkNotNull(type);
        if (Loggers.isEnhancedSubclass(type)) {
            return LoggerFactory.getLogger(type.getSuperclass());
        }
        return LoggerFactory.getLogger(type);
    }

    public static Logger getLogger(Object obj) {
        Preconditions.checkNotNull((Object)obj);
        return Loggers.getLogger(obj.getClass());
    }

    public static Logger getLogger(String name) {
        Preconditions.checkNotNull((Object)name);
        return LoggerFactory.getLogger((String)name);
    }
}

