/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.goodies.common;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;

public class Locks {
    private Locks() {
    }

    public static Lock lock(Lock lock) {
        Preconditions.checkNotNull((Object)lock);
        try {
            if (!lock.tryLock(60L, TimeUnit.SECONDS)) {
                throw new RuntimeException("Failed to obtain lock after 60 seconds");
            }
        }
        catch (InterruptedException e) {
            throw Locks.propagate(e);
        }
        return lock;
    }

    public static Lock read(ReadWriteLock readWriteLock) {
        Preconditions.checkNotNull((Object)readWriteLock);
        return Locks.lock(readWriteLock.readLock());
    }

    public static Lock write(ReadWriteLock readWriteLock) {
        Preconditions.checkNotNull((Object)readWriteLock);
        return Locks.lock(readWriteLock.writeLock());
    }

    private static RuntimeException propagate(Throwable throwable) {
        Throwables.throwIfUnchecked((Throwable)throwable);
        throw new RuntimeException(throwable);
    }
}

