/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.goodies.common;

import com.google.common.base.Preconditions;
import com.google.common.io.Files;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.sonatype.goodies.common.Loggers;

public class FileReplacer {
    private static final AtomicInteger counter = new AtomicInteger(0);
    private static final Logger log = Loggers.getLogger(FileReplacer.class);
    private final File file;
    private final String filePrefix;
    private final File tempFile;
    private final File backupFile;
    private boolean deleteBackupFile;

    public FileReplacer(File file) throws IOException {
        this.file = (File)Preconditions.checkNotNull((Object)file);
        this.filePrefix = file.getName() + "-" + UUID.randomUUID() + "-" + counter.getAndIncrement();
        this.tempFile = new File(file.getParentFile(), this.filePrefix + ".tmp");
        this.backupFile = new File(file.getParentFile(), this.filePrefix + ".bak");
        file.getParentFile().mkdirs();
        if (this.tempFile.exists()) {
            log.warn("Temporary file already exists; removing: {}", (Object)this.tempFile);
            this.delete(this.tempFile);
        }
        this.tempFile.createNewFile();
    }

    public FileReplacer(String fileName) throws IOException {
        this(new File((String)Preconditions.checkNotNull((Object)fileName)));
    }

    private void delete(File file) throws IOException {
        boolean deleted = file.delete();
        if (!deleted) {
            throw new IOException("Failed to delete file: " + file);
        }
    }

    public File getFile() {
        return this.file;
    }

    public File getTempFile() {
        return this.tempFile;
    }

    public File getBackupFile() {
        return this.backupFile;
    }

    public boolean isDeleteBackupFile() {
        return this.deleteBackupFile;
    }

    public void setDeleteBackupFile(boolean deleteBackupFile) {
        this.deleteBackupFile = deleteBackupFile;
    }

    public void replace(ContentWriter writer) throws IOException {
        Preconditions.checkNotNull((Object)writer);
        BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(this.tempFile));
        try {
            try {
                writer.write(output);
            }
            finally {
                output.close();
            }
        }
        catch (IOException e) {
            log.warn("Failed to write temporary file: {}", (Object)this.tempFile, (Object)e);
            throw e;
        }
        this.replaceFile();
    }

    private void replaceFile() throws IOException {
        Preconditions.checkState((boolean)this.tempFile.exists(), (Object)"Temporary file missing");
        if (this.file.exists()) {
            log.trace("Backing up target file: {} -> {}", (Object)this.file, (Object)this.backupFile);
            if (this.backupFile.exists()) {
                log.warn("Backup file already exists; removing: {}", (Object)this.backupFile);
                this.delete(this.backupFile);
            }
            Files.move((File)this.file, (File)this.backupFile);
        }
        log.trace("Replacing file: {} -> {}", (Object)this.tempFile, (Object)this.file);
        Files.move((File)this.tempFile, (File)this.file);
        if (this.backupFile.exists() && this.deleteBackupFile) {
            log.trace("Deleting backup file: {}", (Object)this.backupFile);
            this.delete(this.backupFile);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{file=" + this.file + ", filePrefix='" + this.filePrefix + '\'' + '}';
    }

    public static interface ContentWriter {
        public void write(BufferedOutputStream var1) throws IOException;
    }
}

