/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.servlet;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;

@Named
@Singleton
public class XFrameOptions
implements Serializable {
    private static final long serialVersionUID = 5092514762222572451L;
    private static final String COPYRIGHT_PATH = "/COPYRIGHT.html";
    private static final String HEALTHCHECK_PATH = "/static/healthcheck-tos.html";
    private static final String OSS_LICENSE_PATH = "/OSS-LICENSE.html";
    private static final String PRO_LICENSE_PATH = "/PRO-LICENSE.html";
    private static final String SWAGGER_UI = "/swagger-ui/";
    public static final String DENY = "DENY";
    public static final String SAME_ORIGIN = "SAMEORIGIN";
    private final boolean defaultDeny;
    private final Set<String> frameablePaths;

    @Inject
    public XFrameOptions(@Named(value="${nexus.http.denyframe.enabled:-true}") @Named(value="${nexus.http.denyframe.enabled:-true}") boolean defaultDeny) {
        this.defaultDeny = defaultDeny;
        this.frameablePaths = new HashSet<String>();
        this.frameablePaths.add(COPYRIGHT_PATH);
        this.frameablePaths.add(HEALTHCHECK_PATH);
        this.frameablePaths.add(OSS_LICENSE_PATH);
        this.frameablePaths.add(PRO_LICENSE_PATH);
        this.frameablePaths.add(SWAGGER_UI);
    }

    public String getValueForPath(String path) {
        if (!this.defaultDeny || this.frameablePaths.contains(path)) {
            return SAME_ORIGIN;
        }
        return DENY;
    }
}

