/*
 * Decompiled with CFR 0.152.
 */
package zz.org.yaml.snakeyaml.nodes;

import java.util.List;
import zz.org.yaml.snakeyaml.DumperOptions;
import zz.org.yaml.snakeyaml.error.Mark;
import zz.org.yaml.snakeyaml.nodes.CollectionNode;
import zz.org.yaml.snakeyaml.nodes.Node;
import zz.org.yaml.snakeyaml.nodes.NodeId;
import zz.org.yaml.snakeyaml.nodes.Tag;

public class SequenceNode
extends CollectionNode<Node> {
    private final List<Node> value;

    public SequenceNode(Tag tag, boolean resolved, List<Node> value, Mark startMark, Mark endMark, DumperOptions.FlowStyle flowStyle) {
        super(tag, startMark, endMark, flowStyle);
        if (value == null) {
            throw new NullPointerException("value in a Node is required.");
        }
        this.value = value;
        this.resolved = resolved;
    }

    public SequenceNode(Tag tag, List<Node> value, DumperOptions.FlowStyle flowStyle) {
        this(tag, true, value, null, null, flowStyle);
    }

    @Override
    public NodeId getNodeId() {
        return NodeId.sequence;
    }

    @Override
    public List<Node> getValue() {
        return this.value;
    }

    public void setListType(Class<? extends Object> listType) {
        for (Node node : this.value) {
            node.setType(listType);
        }
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        for (Node node : this.getValue()) {
            if (node instanceof CollectionNode) {
                buf.append(System.identityHashCode(node));
            } else {
                buf.append(node.toString());
            }
            buf.append(",");
        }
        if (buf.length() > 0) {
            buf.deleteCharAt(buf.length() - 1);
        }
        return "<" + this.getClass().getName() + " (tag=" + this.getTag() + ", value=[" + buf + "])>";
    }
}

