/*
 * Decompiled with CFR 0.152.
 */
package zz.org.spdx.utility.compare;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import zz.org.spdx.library.InvalidSPDXAnalysisException;
import zz.org.spdx.library.model.SpdxDocument;
import zz.org.spdx.library.model.SpdxFile;
import zz.org.spdx.library.model.SpdxItem;
import zz.org.spdx.library.model.SpdxSnippet;
import zz.org.spdx.library.model.pointer.StartEndPointer;
import zz.org.spdx.utility.compare.SpdxCompareException;
import zz.org.spdx.utility.compare.SpdxComparer;
import zz.org.spdx.utility.compare.SpdxFileComparer;
import zz.org.spdx.utility.compare.SpdxFileDifference;
import zz.org.spdx.utility.compare.SpdxItemComparer;

public class SpdxSnippetComparer
extends SpdxItemComparer {
    private boolean inProgress = false;
    private boolean differenceFound = false;
    private boolean byteRangeEquals = true;
    private boolean lineRangeEquals = true;
    private boolean snippetFromFilesEquals = true;
    private boolean nameEquals = true;
    Map<SpdxDocument, Map<SpdxDocument, SpdxFileDifference>> snippetFromFileDifferences = new HashMap<SpdxDocument, Map<SpdxDocument, SpdxFileDifference>>();
    Map<SpdxDocument, Map<SpdxDocument, SpdxFile>> uniqueSnippetFromFile = new HashMap<SpdxDocument, Map<SpdxDocument, SpdxFile>>();

    public SpdxSnippetComparer(Map<SpdxDocument, Map<SpdxDocument, Map<String, String>>> extractedLicenseIdMap) {
        super(extractedLicenseIdMap);
    }

    public void addDocumentSnippet(SpdxDocument spdxDocument, SpdxSnippet snippet) throws SpdxCompareException, InvalidSPDXAnalysisException {
        this.checkInProgress();
        if (this.name == null) {
            this.name = snippet.toString();
        }
        this.inProgress = true;
        Iterator iter = this.documentItem.entrySet().iterator();
        SpdxSnippet snippet2 = null;
        SpdxDocument document2 = null;
        while (iter.hasNext() && snippet2 == null) {
            Map.Entry entry = iter.next();
            if (!(entry.getValue() instanceof SpdxSnippet)) continue;
            snippet2 = (SpdxSnippet)entry.getValue();
            document2 = (SpdxDocument)entry.getKey();
        }
        if (snippet2 != null && snippet2.getByteRange() != null) {
            try {
                if (!snippet2.getByteRange().equivalent(snippet.getByteRange())) {
                    this.byteRangeEquals = false;
                    this.differenceFound = true;
                }
            }
            catch (InvalidSPDXAnalysisException e) {
                throw new SpdxCompareException("SPDX error getting byte range: " + e.getMessage());
            }
            try {
                Optional<StartEndPointer> lineRange = snippet.getLineRange();
                Optional<StartEndPointer> lineRange2 = snippet2.getLineRange();
                if (lineRange2.isPresent()) {
                    if (lineRange.isPresent()) {
                        if (!lineRange2.get().equivalent(lineRange.get())) {
                            this.lineRangeEquals = false;
                            this.differenceFound = true;
                        }
                    } else {
                        this.lineRangeEquals = false;
                        this.differenceFound = true;
                    }
                } else if (lineRange.isPresent()) {
                    this.lineRangeEquals = false;
                    this.differenceFound = true;
                }
            }
            catch (InvalidSPDXAnalysisException e) {
                throw new SpdxCompareException("SPDX error getting line range: " + e.getMessage());
            }
            try {
                SpdxFile fromFile = snippet.getSnippetFromFile();
                SpdxFile fromFile2 = snippet2.getSnippetFromFile();
                this.compareSnippetFromFiles(spdxDocument, fromFile, document2, fromFile2);
            }
            catch (InvalidSPDXAnalysisException e) {
                throw new SpdxCompareException("SPDX error getting snippet from file: " + e.getMessage());
            }
            try {
                if (!SpdxComparer.stringsEqual(snippet2.getName(), snippet.getName())) {
                    this.nameEquals = false;
                    this.differenceFound = true;
                }
            }
            catch (InvalidSPDXAnalysisException e) {
                throw new SpdxCompareException("SPDX error comparing snippet names: " + e.getMessage());
            }
        }
        this.inProgress = false;
        super.addDocumentItem(spdxDocument, snippet);
    }

    private void compareSnippetFromFiles(SpdxDocument spdxDocument, SpdxFile fromFile, SpdxDocument document2, SpdxFile fromFile2) throws SpdxCompareException, InvalidSPDXAnalysisException {
        if (fromFile == null) {
            if (fromFile2 != null) {
                Map<SpdxDocument, SpdxFile> unique = this.uniqueSnippetFromFile.get(document2);
                if (unique == null) {
                    unique = new HashMap<SpdxDocument, SpdxFile>();
                    this.uniqueSnippetFromFile.put(document2, unique);
                }
                unique.put(spdxDocument, fromFile2);
                this.snippetFromFilesEquals = false;
            }
        } else if (fromFile2 == null) {
            Map<SpdxDocument, SpdxFile> unique = this.uniqueSnippetFromFile.get(spdxDocument);
            if (unique == null) {
                unique = new HashMap<SpdxDocument, SpdxFile>();
                this.uniqueSnippetFromFile.put(spdxDocument, unique);
            }
            unique.put(document2, fromFile);
            this.snippetFromFilesEquals = false;
        } else if (!Objects.equals(fromFile2.getName(), fromFile.getName())) {
            Map<SpdxDocument, SpdxFile> unique = this.uniqueSnippetFromFile.get(spdxDocument);
            if (unique == null) {
                unique = new HashMap<SpdxDocument, SpdxFile>();
                this.uniqueSnippetFromFile.put(spdxDocument, unique);
            }
            unique.put(document2, fromFile);
            Map<SpdxDocument, SpdxFile> unique2 = this.uniqueSnippetFromFile.get(document2);
            if (unique2 == null) {
                unique2 = new HashMap<SpdxDocument, SpdxFile>();
                this.uniqueSnippetFromFile.put(document2, unique2);
            }
            unique2.put(spdxDocument, fromFile2);
            this.snippetFromFilesEquals = false;
        } else {
            SpdxFileComparer fileCompare = new SpdxFileComparer(this.extractedLicenseIdMap);
            fileCompare.addDocumentFile(spdxDocument, fromFile);
            fileCompare.addDocumentFile(document2, fromFile2);
            if (fileCompare.isDifferenceFound()) {
                this.snippetFromFilesEquals = false;
                HashMap<SpdxDocument, SpdxFileDifference> comparerMap = new HashMap<SpdxDocument, SpdxFileDifference>();
                this.snippetFromFileDifferences.put(spdxDocument, comparerMap);
                Map<SpdxDocument, SpdxFileDifference> comparerMap2 = this.snippetFromFileDifferences.get(document2);
                if (comparerMap2 == null) {
                    comparerMap2 = new HashMap<SpdxDocument, SpdxFileDifference>();
                    this.snippetFromFileDifferences.put(document2, comparerMap2);
                }
                comparerMap.put(document2, fileCompare.getFileDifference(spdxDocument, document2));
                comparerMap2.put(spdxDocument, fileCompare.getFileDifference(document2, spdxDocument));
            }
        }
        if (!this.snippetFromFilesEquals) {
            this.differenceFound = true;
        }
    }

    @Override
    public boolean isDifferenceFound() throws SpdxCompareException {
        this.checkInProgress();
        return this.differenceFound || super.isDifferenceFound();
    }

    @Override
    protected void checkInProgress() throws SpdxCompareException {
        if (this.inProgress) {
            throw new SpdxCompareException("File compare in progress - can not obtain compare results until compare has completed");
        }
        super.checkInProgress();
    }

    public SpdxFileDifference getSnippetFromFileDifference(SpdxDocument docA, SpdxDocument docB) throws SpdxCompareException {
        this.checkInProgress();
        Map<SpdxDocument, SpdxFileDifference> differenceMap = this.snippetFromFileDifferences.get(docA);
        if (differenceMap == null) {
            return null;
        }
        return differenceMap.get(docB);
    }

    public boolean isByteRangeEquals() throws SpdxCompareException {
        this.checkInProgress();
        return this.byteRangeEquals;
    }

    public boolean isLineRangeEquals() throws SpdxCompareException {
        this.checkInProgress();
        return this.lineRangeEquals;
    }

    public boolean isSnippetFromFilesEquals() throws SpdxCompareException {
        this.checkInProgress();
        return this.snippetFromFilesEquals;
    }

    public boolean isNameEquals() throws SpdxCompareException {
        this.checkInProgress();
        return this.nameEquals;
    }

    public SpdxFile getUniqueSnippetFromFile(SpdxDocument docA, SpdxDocument docB) throws SpdxCompareException {
        this.checkInProgress();
        Map<SpdxDocument, SpdxFile> docMap = this.uniqueSnippetFromFile.get(docA);
        if (docMap == null) {
            return null;
        }
        return docMap.get(docB);
    }

    public int getNumSnippets() {
        return this.documentItem.size();
    }

    public SpdxSnippet getDocSnippet(SpdxDocument spdxDocument) {
        SpdxItem retItem = (SpdxItem)this.documentItem.get(spdxDocument);
        if (retItem != null && retItem instanceof SpdxSnippet) {
            return (SpdxSnippet)retItem;
        }
        return null;
    }
}

