/*
 * Decompiled with CFR 0.152.
 */
package zz.org.spdx.utility.compare;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import zz.org.spdx.library.InvalidSPDXAnalysisException;
import zz.org.spdx.library.model.Annotation;
import zz.org.spdx.library.model.Relationship;
import zz.org.spdx.library.model.SpdxDocument;
import zz.org.spdx.library.model.SpdxItem;
import zz.org.spdx.library.model.license.AnyLicenseInfo;
import zz.org.spdx.utility.compare.LicenseCompareHelper;
import zz.org.spdx.utility.compare.SpdxCompareException;
import zz.org.spdx.utility.compare.SpdxComparer;
import zz.org.spdx.utility.compare.SpdxSnippetComparer;

public class SpdxItemComparer {
    private boolean itemInProgress = false;
    private boolean itemDifferenceFound = false;
    private boolean concludedLicenseEquals = true;
    private boolean seenLicenseEquals = true;
    protected String name = null;
    private Map<SpdxDocument, Map<SpdxDocument, List<AnyLicenseInfo>>> uniqueLicenseInfosInFiles = new HashMap<SpdxDocument, Map<SpdxDocument, List<AnyLicenseInfo>>>();
    private boolean commentsEquals = true;
    private boolean copyrightsEquals = true;
    private boolean licenseCommmentsEquals = true;
    private boolean relationshipsEquals = true;
    private boolean attributionTextEquals = true;
    Map<SpdxDocument, Map<SpdxDocument, List<Relationship>>> uniqueRelationships = new HashMap<SpdxDocument, Map<SpdxDocument, List<Relationship>>>();
    private boolean annotationsEquals = true;
    private Map<SpdxDocument, Map<SpdxDocument, List<Annotation>>> uniqueAnnotations = new HashMap<SpdxDocument, Map<SpdxDocument, List<Annotation>>>();
    protected Map<SpdxDocument, SpdxItem> documentItem = new HashMap<SpdxDocument, SpdxItem>();
    protected Map<SpdxDocument, Map<SpdxDocument, Map<String, String>>> extractedLicenseIdMap;

    public SpdxItemComparer(Map<SpdxDocument, Map<SpdxDocument, Map<String, String>>> extractedLicenseIdMap) {
        this.extractedLicenseIdMap = extractedLicenseIdMap;
    }

    public void addDocumentItem(SpdxDocument spdxDocument, SpdxItem spdxItem) throws SpdxCompareException, InvalidSPDXAnalysisException {
        if (this.itemInProgress) {
            new SpdxCompareException("Trying to add a document item while another document item is being added.");
        }
        Optional<String> oName = spdxItem.getName();
        if (this.name == null) {
            if (oName.isPresent()) {
                this.name = oName.get();
            }
        } else if (oName.isPresent() && !this.name.equals(oName.get()) && !(this instanceof SpdxSnippetComparer)) {
            new SpdxCompareException("Names do not match for item being added to comparer: " + spdxItem.getName() + ", expecting " + this.name);
        }
        this.itemInProgress = true;
        Iterator<Map.Entry<SpdxDocument, SpdxItem>> iter = this.documentItem.entrySet().iterator();
        if (iter.hasNext()) {
            Map.Entry<SpdxDocument, SpdxItem> entry = iter.next();
            SpdxItem itemB = entry.getValue();
            Map<String, String> licenseXlationMap = this.extractedLicenseIdMap.get(spdxDocument).get(entry.getKey());
            if (!SpdxComparer.stringsEqual(spdxItem.getComment(), itemB.getComment())) {
                this.commentsEquals = false;
                this.itemDifferenceFound = true;
            }
            if (!LicenseCompareHelper.isLicenseEqual(spdxItem.getLicenseConcluded(), itemB.getLicenseConcluded(), licenseXlationMap)) {
                this.concludedLicenseEquals = false;
                this.itemDifferenceFound = true;
            }
            if (!SpdxComparer.stringsEqual(spdxItem.getCopyrightText(), itemB.getCopyrightText())) {
                this.copyrightsEquals = false;
                this.itemDifferenceFound = true;
            }
            if (!SpdxComparer.stringsEqual(spdxItem.getLicenseComments(), itemB.getLicenseComments())) {
                this.licenseCommmentsEquals = false;
                this.itemDifferenceFound = true;
            }
            if (!SpdxComparer.collectionsEquals(spdxItem.getAttributionText(), itemB.getAttributionText())) {
                this.attributionTextEquals = false;
                this.itemDifferenceFound = true;
            }
            this.compareLicenseInfosInFiles(spdxDocument, spdxItem.getLicenseInfoFromFiles());
            this.compareRelationships(spdxDocument, spdxItem.getRelationships());
            this.compareAnnotation(spdxDocument, spdxItem.getAnnotations());
        }
        this.documentItem.put(spdxDocument, spdxItem);
        this.itemInProgress = false;
    }

    private void compareAnnotation(SpdxDocument spdxDocument, Collection<Annotation> annotations) throws InvalidSPDXAnalysisException {
        Map<SpdxDocument, List<Annotation>> uniqueDocAnnotations = this.uniqueAnnotations.get(spdxDocument);
        if (uniqueDocAnnotations == null) {
            uniqueDocAnnotations = new HashMap<SpdxDocument, List<Annotation>>();
            this.uniqueAnnotations.put(spdxDocument, uniqueDocAnnotations);
        }
        for (Map.Entry<SpdxDocument, SpdxItem> entry : this.documentItem.entrySet()) {
            Collection<Annotation> compareAnnotations;
            List<Annotation> uniqueAnnotations;
            Map<SpdxDocument, List<Annotation>> compareDocAnnotations = this.uniqueAnnotations.get(entry.getKey());
            if (compareDocAnnotations == null) {
                compareDocAnnotations = new HashMap<SpdxDocument, List<Annotation>>();
                this.uniqueAnnotations.put(entry.getKey(), compareDocAnnotations);
            }
            if ((uniqueAnnotations = SpdxComparer.findUniqueAnnotations(annotations, compareAnnotations = entry.getValue().getAnnotations())).size() > 0) {
                this.annotationsEquals = false;
                this.itemDifferenceFound = true;
            }
            uniqueDocAnnotations.put(entry.getKey(), uniqueAnnotations);
            uniqueAnnotations = SpdxComparer.findUniqueAnnotations(compareAnnotations, annotations);
            if (uniqueAnnotations.size() > 0) {
                this.annotationsEquals = false;
                this.itemDifferenceFound = true;
            }
            compareDocAnnotations.put(spdxDocument, uniqueAnnotations);
        }
    }

    private void compareRelationships(SpdxDocument spdxDocument, Collection<Relationship> relationships) throws InvalidSPDXAnalysisException {
        Map<SpdxDocument, List<Relationship>> uniqueDocRelationship = this.uniqueRelationships.get(spdxDocument);
        if (uniqueDocRelationship == null) {
            uniqueDocRelationship = new HashMap<SpdxDocument, List<Relationship>>();
            this.uniqueRelationships.put(spdxDocument, uniqueDocRelationship);
        }
        for (Map.Entry<SpdxDocument, SpdxItem> entry : this.documentItem.entrySet()) {
            Collection<Relationship> compareRelationships;
            List<Relationship> uniqueRelationships;
            Map<SpdxDocument, List<Relationship>> uniqueCompareRelationship = this.uniqueRelationships.get(entry.getKey());
            if (uniqueCompareRelationship == null) {
                uniqueCompareRelationship = new HashMap<SpdxDocument, List<Relationship>>();
                this.uniqueRelationships.put(entry.getKey(), uniqueCompareRelationship);
            }
            if ((uniqueRelationships = SpdxComparer.findUniqueRelationships(relationships, compareRelationships = entry.getValue().getRelationships())).size() > 0) {
                this.relationshipsEquals = false;
                this.itemDifferenceFound = true;
            }
            uniqueDocRelationship.put(entry.getKey(), uniqueRelationships);
            uniqueRelationships = SpdxComparer.findUniqueRelationships(compareRelationships, relationships);
            if (uniqueRelationships.size() > 0) {
                this.relationshipsEquals = false;
                this.itemDifferenceFound = true;
            }
            uniqueCompareRelationship.put(spdxDocument, uniqueRelationships);
        }
    }

    private void compareLicenseInfosInFiles(SpdxDocument spdxDocument, Collection<AnyLicenseInfo> licenses) throws SpdxCompareException, InvalidSPDXAnalysisException {
        Map<SpdxDocument, List<AnyLicenseInfo>> uniqueDocLicenses = this.uniqueLicenseInfosInFiles.get(spdxDocument);
        if (uniqueDocLicenses == null) {
            uniqueDocLicenses = new HashMap<SpdxDocument, List<AnyLicenseInfo>>();
            this.uniqueLicenseInfosInFiles.put(spdxDocument, uniqueDocLicenses);
        }
        for (Map.Entry<SpdxDocument, SpdxItem> entry : this.documentItem.entrySet()) {
            Map<SpdxDocument, List<AnyLicenseInfo>> uniqueCompareLicenses = this.uniqueLicenseInfosInFiles.get(entry.getKey());
            if (uniqueCompareLicenses == null) {
                uniqueCompareLicenses = new HashMap<SpdxDocument, List<AnyLicenseInfo>>();
                this.uniqueLicenseInfosInFiles.put(entry.getKey(), uniqueCompareLicenses);
            }
            Collection<AnyLicenseInfo> compareLicenses = entry.getValue().getLicenseInfoFromFiles();
            ArrayList<AnyLicenseInfo> uniqueInDoc = new ArrayList<AnyLicenseInfo>();
            ArrayList<AnyLicenseInfo> uniqueInCompare = new ArrayList<AnyLicenseInfo>();
            Map<String, String> licenseXlationMap = this.extractedLicenseIdMap.get(spdxDocument).get(entry.getKey());
            this.compareLicenseCollections(licenses, compareLicenses, uniqueInDoc, uniqueInCompare, licenseXlationMap);
            if (uniqueInDoc.size() > 0 || uniqueInCompare.size() > 0) {
                this.seenLicenseEquals = false;
                this.itemDifferenceFound = true;
            }
            uniqueDocLicenses.put(entry.getKey(), uniqueInDoc);
            uniqueCompareLicenses.put(spdxDocument, uniqueInCompare);
        }
    }

    private void compareLicenseCollections(Collection<AnyLicenseInfo> licensesA, Collection<AnyLicenseInfo> licensesB, List<AnyLicenseInfo> alUniqueA, List<AnyLicenseInfo> alUniqueB, Map<String, String> licenseXlationMap) throws SpdxCompareException, InvalidSPDXAnalysisException {
        boolean found;
        for (AnyLicenseInfo licA : licensesA) {
            found = false;
            for (AnyLicenseInfo licB : licensesB) {
                if (!LicenseCompareHelper.isLicenseEqual(licA, licB, licenseXlationMap)) continue;
                found = true;
                break;
            }
            if (found) continue;
            alUniqueA.add(licA);
        }
        for (AnyLicenseInfo licB : licensesB) {
            found = false;
            for (AnyLicenseInfo licA : licensesA) {
                if (!LicenseCompareHelper.isLicenseEqual(licA, licB, licenseXlationMap)) continue;
                found = true;
                break;
            }
            if (found) continue;
            alUniqueB.add(licB);
        }
    }

    public boolean isConcludedLicenseEquals() throws SpdxCompareException {
        this.checkInProgress();
        this.checkCompareMade();
        return this.concludedLicenseEquals;
    }

    public boolean isSeenLicenseEquals() throws SpdxCompareException {
        this.checkInProgress();
        this.checkCompareMade();
        return this.seenLicenseEquals;
    }

    public List<AnyLicenseInfo> getUniqueSeenLicenses(SpdxDocument docA, SpdxDocument docB) throws SpdxCompareException {
        this.checkInProgress();
        this.checkCompareMade();
        Map<SpdxDocument, List<AnyLicenseInfo>> unique = this.uniqueLicenseInfosInFiles.get(docA);
        if (unique == null) {
            return new ArrayList<AnyLicenseInfo>();
        }
        List<AnyLicenseInfo> retval = unique.get(docB);
        if (retval == null) {
            return new ArrayList<AnyLicenseInfo>();
        }
        return retval;
    }

    public boolean isCommentsEquals() throws SpdxCompareException {
        this.checkInProgress();
        this.checkCompareMade();
        return this.commentsEquals;
    }

    public boolean isCopyrightsEquals() throws SpdxCompareException {
        this.checkInProgress();
        this.checkCompareMade();
        return this.copyrightsEquals;
    }

    public boolean isLicenseCommmentsEquals() throws SpdxCompareException {
        this.checkInProgress();
        this.checkCompareMade();
        return this.licenseCommmentsEquals;
    }

    protected void checkInProgress() throws SpdxCompareException {
        if (this.itemInProgress) {
            new SpdxCompareException("File compare in progress - can not obtain compare results until compare has completed");
        }
    }

    protected void checkCompareMade() throws SpdxCompareException {
        if (this.documentItem.entrySet().size() < 1) {
            new SpdxCompareException("Trying to obtain results of a file compare before a file compare has been performed");
        }
    }

    public boolean isDifferenceFound() throws SpdxCompareException {
        this.checkInProgress();
        this.checkCompareMade();
        return this.itemDifferenceFound;
    }

    public boolean isInProgress() throws SpdxCompareException {
        this.checkInProgress();
        this.checkCompareMade();
        return this.itemInProgress;
    }

    public SpdxItem getItem(SpdxDocument doc) throws SpdxCompareException {
        this.checkInProgress();
        this.checkCompareMade();
        return this.documentItem.get(doc);
    }

    public boolean isRelationshipsEquals() throws SpdxCompareException {
        this.checkInProgress();
        this.checkCompareMade();
        return this.relationshipsEquals;
    }

    public List<Relationship> getUniqueRelationship(SpdxDocument docA, SpdxDocument docB) throws SpdxCompareException {
        this.checkInProgress();
        this.checkCompareMade();
        Map<SpdxDocument, List<Relationship>> unique = this.uniqueRelationships.get(docA);
        if (unique == null) {
            return new ArrayList<Relationship>();
        }
        List<Relationship> retval = unique.get(docB);
        if (retval == null) {
            return new ArrayList<Relationship>();
        }
        return retval;
    }

    public boolean isAnnotationsEquals() throws SpdxCompareException {
        this.checkInProgress();
        this.checkCompareMade();
        return this.annotationsEquals;
    }

    public boolean isAttributionTextEquals() throws SpdxCompareException {
        this.checkInProgress();
        this.checkCompareMade();
        return this.attributionTextEquals;
    }

    public List<Annotation> getUniqueAnnotations(SpdxDocument docA, SpdxDocument docB) throws SpdxCompareException {
        this.checkInProgress();
        this.checkCompareMade();
        Map<SpdxDocument, List<Annotation>> unique = this.uniqueAnnotations.get(docA);
        if (unique == null) {
            return new ArrayList<Annotation>();
        }
        List<Annotation> retval = unique.get(docB);
        if (retval == null) {
            return new ArrayList<Annotation>();
        }
        return retval;
    }
}

