/*
 * Decompiled with CFR 0.152.
 */
package zz.org.spdx.library;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Objects;
import zz.org.spdx.library.InvalidSPDXAnalysisException;
import zz.org.spdx.storage.IModelStore;
import zz.org.spdx.storage.ISerializableModelStore;

public class Write {
    public static void applyUpdatesInOneTransaction(String documentUri, IModelStore modelStore, IModelStore.ModelUpdate ... updates) throws InvalidSPDXAnalysisException, IOException {
        Write.applyUpdatesInOneTransaction(documentUri, modelStore, Arrays.asList(updates));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void applyUpdatesInOneTransaction(String documentUri, IModelStore modelStore, Iterable<? extends IModelStore.ModelUpdate> updates) throws InvalidSPDXAnalysisException, IOException {
        IModelStore.IModelStoreLock lock = modelStore.enterCriticalSection(documentUri, false);
        try {
            for (IModelStore.ModelUpdate modelUpdate : updates) {
                modelUpdate.apply();
            }
        }
        finally {
            modelStore.leaveCriticalSection(lock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deSerialize(ISerializableModelStore modelStore, String documentUri, InputStream stream) throws InvalidSPDXAnalysisException, IOException {
        IModelStore.IModelStoreLock lock = modelStore.enterCriticalSection(documentUri, false);
        try {
            modelStore.deSerialize(stream, false);
        }
        finally {
            modelStore.leaveCriticalSection(lock);
        }
    }

    public static void readFile(ISerializableModelStore modelStore, String documentUri, Path filePath) throws InvalidSPDXAnalysisException, IOException {
        Objects.requireNonNull(modelStore, "Model store can not be null");
        Objects.requireNonNull(documentUri, "Document URI can not be null");
        Objects.requireNonNull(filePath, "File path can not be null");
        try (InputStream is = Files.newInputStream(filePath, new OpenOption[0]);){
            Write.deSerialize(modelStore, documentUri, is);
        }
    }
}

