/*
 * Decompiled with CFR 0.152.
 */
package zz.org.eclipse.jgit.util.sha1;

import java.security.MessageDigest;
import zz.org.eclipse.jgit.lib.Constants;
import zz.org.eclipse.jgit.lib.MutableObjectId;
import zz.org.eclipse.jgit.lib.ObjectId;
import zz.org.eclipse.jgit.util.sha1.SHA1;
import zz.org.eclipse.jgit.util.sha1.Sha1CollisionException;

class SHA1Native
extends SHA1 {
    private final MessageDigest md = Constants.newMessageDigest();

    SHA1Native() {
    }

    @Override
    public void update(byte b) {
        this.md.update(b);
    }

    @Override
    public void update(byte[] in) {
        this.md.update(in);
    }

    @Override
    public void update(byte[] in, int p, int len) {
        this.md.update(in, p, len);
    }

    @Override
    public byte[] digest() throws Sha1CollisionException {
        return this.md.digest();
    }

    @Override
    public ObjectId toObjectId() throws Sha1CollisionException {
        return ObjectId.fromRaw(this.md.digest());
    }

    @Override
    public void digest(MutableObjectId id) throws Sha1CollisionException {
        id.fromRaw(this.md.digest());
    }

    @Override
    public SHA1 reset() {
        this.md.reset();
        return this;
    }

    @Override
    public SHA1 setDetectCollision(boolean detect) {
        return this;
    }

    @Override
    public boolean hasCollision() {
        return false;
    }
}

