/*
 * Decompiled with CFR 0.152.
 */
package zz.org.eclipse.jgit.transport;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.function.Consumer;
import zz.org.eclipse.jgit.errors.InvalidObjectIdException;
import zz.org.eclipse.jgit.errors.PackProtocolException;
import zz.org.eclipse.jgit.internal.JGitText;
import zz.org.eclipse.jgit.lib.ObjectId;
import zz.org.eclipse.jgit.transport.FetchV2Request;
import zz.org.eclipse.jgit.transport.FilterSpec;
import zz.org.eclipse.jgit.transport.LsRefsV2Request;
import zz.org.eclipse.jgit.transport.ObjectInfoRequest;
import zz.org.eclipse.jgit.transport.PacketLineIn;
import zz.org.eclipse.jgit.transport.TransferConfig;

final class ProtocolV2Parser {
    private final TransferConfig transferConfig;

    ProtocolV2Parser(TransferConfig transferConfig) {
        this.transferConfig = transferConfig;
    }

    private static String consumeCapabilities(PacketLineIn pckIn, Consumer<String> serverOptionConsumer, Consumer<String> agentConsumer) throws IOException {
        String serverOptionPrefix = "server-option=";
        String agentPrefix = "agent=";
        String line = pckIn.readString();
        while (!PacketLineIn.isDelimiter(line) && !PacketLineIn.isEnd(line)) {
            if (line.startsWith(serverOptionPrefix)) {
                serverOptionConsumer.accept(line.substring(serverOptionPrefix.length()));
            } else if (line.startsWith(agentPrefix)) {
                agentConsumer.accept(line.substring(agentPrefix.length()));
            }
            line = pckIn.readString();
        }
        return line;
    }

    FetchV2Request parseFetchRequest(PacketLineIn pckIn) throws PackProtocolException, IOException {
        FetchV2Request.Builder reqBuilder = FetchV2Request.builder();
        reqBuilder.addClientCapability("side-band-64k");
        String line = ProtocolV2Parser.consumeCapabilities(pckIn, serverOption -> {
            FetchV2Request.Builder builder2 = reqBuilder.addServerOption((String)serverOption);
        }, agent -> {
            FetchV2Request.Builder builder2 = reqBuilder.setAgent((String)agent);
        });
        if (PacketLineIn.isEnd(line)) {
            return reqBuilder.build();
        }
        if (!PacketLineIn.isDelimiter(line)) {
            throw new PackProtocolException(MessageFormat.format(JGitText.get().unexpectedPacketLine, line));
        }
        boolean filterReceived = false;
        for (String line2 : pckIn.readStrings()) {
            if (line2.startsWith("want ")) {
                reqBuilder.addWantId(ObjectId.fromString(line2.substring(5)));
                continue;
            }
            if (this.transferConfig.isAllowRefInWant() && line2.startsWith("want-ref ")) {
                reqBuilder.addWantedRef(line2.substring("want-ref".length() + 1));
                continue;
            }
            if (line2.startsWith("have ")) {
                reqBuilder.addPeerHas(ObjectId.fromString(line2.substring(5)));
                continue;
            }
            if (line2.equals("done")) {
                reqBuilder.setDoneReceived();
                continue;
            }
            if (line2.equals("wait-for-done")) {
                reqBuilder.setWaitForDone();
                continue;
            }
            if (line2.equals("thin-pack")) {
                reqBuilder.addClientCapability("thin-pack");
                continue;
            }
            if (line2.equals("no-progress")) {
                reqBuilder.addClientCapability("no-progress");
                continue;
            }
            if (line2.equals("include-tag")) {
                reqBuilder.addClientCapability("include-tag");
                continue;
            }
            if (line2.equals("ofs-delta")) {
                reqBuilder.addClientCapability("ofs-delta");
                continue;
            }
            if (line2.startsWith("shallow ")) {
                reqBuilder.addClientShallowCommit(ObjectId.fromString(line2.substring(8)));
                continue;
            }
            if (line2.startsWith("deepen ")) {
                int parsedDepth = Integer.parseInt(line2.substring(7));
                if (parsedDepth <= 0) {
                    throw new PackProtocolException(MessageFormat.format(JGitText.get().invalidDepth, parsedDepth));
                }
                if (reqBuilder.getDeepenSince() != 0) {
                    throw new PackProtocolException(JGitText.get().deepenSinceWithDeepen);
                }
                if (reqBuilder.hasDeepenNotRefs()) {
                    throw new PackProtocolException(JGitText.get().deepenNotWithDeepen);
                }
                reqBuilder.setDepth(parsedDepth);
                continue;
            }
            if (line2.startsWith("deepen-not ")) {
                reqBuilder.addDeepenNotRef(line2.substring(11));
                if (reqBuilder.getDepth() == 0) continue;
                throw new PackProtocolException(JGitText.get().deepenNotWithDeepen);
            }
            if (line2.equals("deepen-relative")) {
                reqBuilder.addClientCapability("deepen-relative");
                continue;
            }
            if (line2.startsWith("deepen-since ")) {
                int ts = Integer.parseInt(line2.substring(13));
                if (ts <= 0) {
                    throw new PackProtocolException(MessageFormat.format(JGitText.get().invalidTimestamp, line2));
                }
                if (reqBuilder.getDepth() != 0) {
                    throw new PackProtocolException(JGitText.get().deepenSinceWithDeepen);
                }
                reqBuilder.setDeepenSince(ts);
                continue;
            }
            if (this.transferConfig.isAllowFilter() && line2.startsWith("filter ")) {
                if (filterReceived) {
                    throw new PackProtocolException(JGitText.get().tooManyFilters);
                }
                filterReceived = true;
                reqBuilder.setFilterSpec(FilterSpec.fromFilterLine(line2.substring("filter".length() + 1)));
                continue;
            }
            if (this.transferConfig.isAllowSidebandAll() && line2.equals("sideband-all")) {
                reqBuilder.setSidebandAll(true);
                continue;
            }
            if (line2.startsWith("packfile-uris ")) {
                String[] stringArray = line2.substring(14).split(",");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String s = stringArray[n2];
                    reqBuilder.addPackfileUriProtocol(s);
                    ++n2;
                }
                continue;
            }
            throw new PackProtocolException(MessageFormat.format(JGitText.get().unexpectedPacketLine, line2));
        }
        return reqBuilder.build();
    }

    LsRefsV2Request parseLsRefsRequest(PacketLineIn pckIn) throws PackProtocolException, IOException {
        LsRefsV2Request.Builder builder = LsRefsV2Request.builder();
        ArrayList<String> prefixes = new ArrayList<String>();
        String line = ProtocolV2Parser.consumeCapabilities(pckIn, serverOption -> {
            LsRefsV2Request.Builder builder2 = builder.addServerOption((String)serverOption);
        }, agent -> {
            LsRefsV2Request.Builder builder2 = builder.setAgent((String)agent);
        });
        if (PacketLineIn.isEnd(line)) {
            return builder.build();
        }
        if (!PacketLineIn.isDelimiter(line)) {
            throw new PackProtocolException(MessageFormat.format(JGitText.get().unexpectedPacketLine, line));
        }
        for (String line2 : pckIn.readStrings()) {
            if (line2.equals("peel")) {
                builder.setPeel(true);
                continue;
            }
            if (line2.equals("symrefs")) {
                builder.setSymrefs(true);
                continue;
            }
            if (line2.startsWith("ref-prefix ")) {
                prefixes.add(line2.substring("ref-prefix ".length()));
                continue;
            }
            throw new PackProtocolException(MessageFormat.format(JGitText.get().unexpectedPacketLine, line2));
        }
        return builder.setRefPrefixes(prefixes).build();
    }

    ObjectInfoRequest parseObjectInfoRequest(PacketLineIn pckIn) throws PackProtocolException, IOException {
        ObjectInfoRequest.Builder builder = ObjectInfoRequest.builder();
        ArrayList<ObjectId> objectIDs = new ArrayList<ObjectId>();
        String line = pckIn.readString();
        if (PacketLineIn.isEnd(line)) {
            return builder.build();
        }
        if (!line.equals("size")) {
            throw new PackProtocolException(MessageFormat.format(JGitText.get().unexpectedPacketLine, line));
        }
        for (String line2 : pckIn.readStrings()) {
            if (!line2.startsWith("oid ")) {
                throw new PackProtocolException(MessageFormat.format(JGitText.get().unexpectedPacketLine, line2));
            }
            String oidStr = line2.substring("oid ".length());
            try {
                objectIDs.add(ObjectId.fromString(oidStr));
            }
            catch (InvalidObjectIdException e) {
                throw new PackProtocolException(MessageFormat.format(JGitText.get().invalidObject, oidStr), e);
            }
        }
        return builder.setObjectIDs(objectIDs).build();
    }
}

