/*
 * Decompiled with CFR 0.152.
 */
package zz.org.eclipse.jgit.transport;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import zz.org.eclipse.jgit.transport.CapabilitiesV2Request;
import zz.org.eclipse.jgit.transport.FetchV2Request;
import zz.org.eclipse.jgit.transport.LsRefsV2Request;
import zz.org.eclipse.jgit.transport.ObjectInfoRequest;
import zz.org.eclipse.jgit.transport.ProtocolV2Hook;
import zz.org.eclipse.jgit.transport.ServiceMayNotContinueException;

public class ProtocolV2HookChain
implements ProtocolV2Hook {
    private final List<? extends ProtocolV2Hook> hooks;

    public static ProtocolV2Hook newChain(List<? extends ProtocolV2Hook> hooks) {
        List newHooks = hooks.stream().filter(hook -> !hook.equals(ProtocolV2Hook.DEFAULT)).collect(Collectors.toList());
        if (newHooks.isEmpty()) {
            return ProtocolV2Hook.DEFAULT;
        }
        if (newHooks.size() == 1) {
            return (ProtocolV2Hook)newHooks.get(0);
        }
        return new ProtocolV2HookChain(newHooks);
    }

    @Override
    public void onCapabilities(CapabilitiesV2Request req) throws ServiceMayNotContinueException {
        for (ProtocolV2Hook protocolV2Hook : this.hooks) {
            protocolV2Hook.onCapabilities(req);
        }
    }

    @Override
    public void onLsRefs(LsRefsV2Request req) throws ServiceMayNotContinueException {
        for (ProtocolV2Hook protocolV2Hook : this.hooks) {
            protocolV2Hook.onLsRefs(req);
        }
    }

    @Override
    public void onFetch(FetchV2Request req) throws ServiceMayNotContinueException {
        for (ProtocolV2Hook protocolV2Hook : this.hooks) {
            protocolV2Hook.onFetch(req);
        }
    }

    @Override
    public void onObjectInfo(ObjectInfoRequest req) throws ServiceMayNotContinueException {
        for (ProtocolV2Hook protocolV2Hook : this.hooks) {
            protocolV2Hook.onObjectInfo(req);
        }
    }

    private ProtocolV2HookChain(List<? extends ProtocolV2Hook> hooks) {
        this.hooks = Collections.unmodifiableList(hooks);
    }
}

