/*
 * Decompiled with CFR 0.152.
 */
package zz.org.eclipse.jgit.transport;

import java.io.IOException;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.UncheckedIOException;
import zz.org.eclipse.jgit.errors.TransportException;
import zz.org.eclipse.jgit.internal.JGitText;
import zz.org.eclipse.jgit.lib.Repository;
import zz.org.eclipse.jgit.transport.BasePackPushConnection;
import zz.org.eclipse.jgit.transport.PackTransport;
import zz.org.eclipse.jgit.transport.ReceivePack;
import zz.org.eclipse.jgit.transport.resolver.ReceivePackFactory;
import zz.org.eclipse.jgit.transport.resolver.ServiceNotAuthorizedException;
import zz.org.eclipse.jgit.transport.resolver.ServiceNotEnabledException;

class InternalPushConnection<C>
extends BasePackPushConnection {
    private Thread worker;

    public InternalPushConnection(PackTransport transport, final ReceivePackFactory<C> receivePackFactory, final C req, final Repository remote) throws TransportException {
        super(transport);
        PipedOutputStream out_w;
        PipedInputStream out_r;
        PipedOutputStream in_w;
        PipedInputStream in_r;
        try {
            in_r = new PipedInputStream();
            in_w = new PipedOutputStream(in_r);
            out_r = new PipedInputStream();
            out_w = new PipedOutputStream(out_r);
        }
        catch (IOException err) {
            remote.close();
            throw new TransportException(this.uri, JGitText.get().cannotConnectPipes, err);
        }
        this.worker = new Thread("JGit-Receive-Pack"){

            @Override
            public void run() {
                try {
                    try {
                        ReceivePack rp = receivePackFactory.create(req, remote);
                        rp.receive(out_r, in_w, System.err);
                    }
                    catch (ServiceNotAuthorizedException | ServiceNotEnabledException rp) {
                        try {
                            out_r.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        try {
                            in_w.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        remote.close();
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                }
                finally {
                    try {
                        out_r.close();
                    }
                    catch (IOException iOException) {}
                    try {
                        in_w.close();
                    }
                    catch (IOException iOException) {}
                    remote.close();
                }
            }
        };
        this.worker.start();
        this.init(in_r, out_w);
        this.readAdvertisedRefs();
    }

    @Override
    public void close() {
        super.close();
        if (this.worker != null) {
            try {
                try {
                    this.worker.join();
                }
                catch (InterruptedException interruptedException) {
                    this.worker = null;
                }
            }
            finally {
                this.worker = null;
            }
        }
    }
}

