/*
 * Decompiled with CFR 0.152.
 */
package zz.org.eclipse.jgit.revwalk;

import java.io.IOException;
import zz.org.eclipse.jgit.errors.IncorrectObjectTypeException;
import zz.org.eclipse.jgit.errors.MissingObjectException;
import zz.org.eclipse.jgit.revwalk.BlockRevQueue;
import zz.org.eclipse.jgit.revwalk.Generator;
import zz.org.eclipse.jgit.revwalk.RevCommit;

public class LIFORevQueue
extends BlockRevQueue {
    private BlockRevQueue.Block head;

    public LIFORevQueue() {
        super(false);
    }

    LIFORevQueue(Generator s) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        super(s);
    }

    @Override
    public void add(RevCommit c) {
        BlockRevQueue.Block b = this.head;
        if (b == null || !b.canUnpop()) {
            b = this.free.newBlock();
            b.resetToEnd();
            b.next = this.head;
            this.head = b;
        }
        b.unpop(c);
    }

    @Override
    public RevCommit next() {
        BlockRevQueue.Block b = this.head;
        if (b == null) {
            return null;
        }
        RevCommit c = b.pop();
        if (b.isEmpty()) {
            this.head = b.next;
            this.free.freeBlock(b);
        }
        return c;
    }

    @Override
    public void clear() {
        this.head = null;
        this.free.clear();
    }

    @Override
    boolean everbodyHasFlag(int f) {
        BlockRevQueue.Block b = this.head;
        while (b != null) {
            int i = b.headIndex;
            while (i < b.tailIndex) {
                if ((b.commits[i].flags & f) == 0) {
                    return false;
                }
                ++i;
            }
            b = b.next;
        }
        return true;
    }

    @Override
    boolean anybodyHasFlag(int f) {
        BlockRevQueue.Block b = this.head;
        while (b != null) {
            int i = b.headIndex;
            while (i < b.tailIndex) {
                if ((b.commits[i].flags & f) != 0) {
                    return true;
                }
                ++i;
            }
            b = b.next;
        }
        return false;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        BlockRevQueue.Block q = this.head;
        while (q != null) {
            int i = q.headIndex;
            while (i < q.tailIndex) {
                LIFORevQueue.describe(s, q.commits[i]);
                ++i;
            }
            q = q.next;
        }
        return s.toString();
    }
}

