/*
 * Decompiled with CFR 0.152.
 */
package zz.org.eclipse.jgit.internal.storage.dfs;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import zz.org.eclipse.jgit.annotations.Nullable;
import zz.org.eclipse.jgit.internal.storage.dfs.DfsRepositoryDescription;
import zz.org.eclipse.jgit.internal.storage.pack.PackExt;

public abstract class DfsStreamKey {
    final int hash;
    final int packExtPos;

    public static DfsStreamKey of(DfsRepositoryDescription repo, String name, @Nullable PackExt ext) {
        return new ByteArrayDfsStreamKey(repo, name.getBytes(StandardCharsets.UTF_8), ext);
    }

    protected DfsStreamKey(int hash, @Nullable PackExt ext) {
        this.hash = hash * 31;
        this.packExtPos = ext == null ? 0 : ext.getPosition();
    }

    public int hashCode() {
        return this.hash;
    }

    public abstract boolean equals(Object var1);

    public String toString() {
        return String.format("DfsStreamKey[hash=%08x]", this.hash);
    }

    private static final class ByteArrayDfsStreamKey
    extends DfsStreamKey {
        private final DfsRepositoryDescription repo;
        private final byte[] name;

        ByteArrayDfsStreamKey(DfsRepositoryDescription repo, byte[] name, @Nullable PackExt ext) {
            super(repo.hashCode() * 31 + Arrays.hashCode(name), ext);
            this.repo = repo;
            this.name = name;
        }

        @Override
        public boolean equals(Object o) {
            if (o instanceof ByteArrayDfsStreamKey) {
                ByteArrayDfsStreamKey k = (ByteArrayDfsStreamKey)o;
                return this.hash == k.hash && this.repo.equals(k.repo) && Arrays.equals(this.name, k.name);
            }
            return false;
        }
    }

    static final class ForReverseIndex
    extends DfsStreamKey {
        private final DfsStreamKey idxKey;

        ForReverseIndex(DfsStreamKey idxKey) {
            super(idxKey.hash + 1, null);
            this.idxKey = idxKey;
        }

        @Override
        public boolean equals(Object o) {
            return o instanceof ForReverseIndex && this.idxKey.equals(((ForReverseIndex)o).idxKey);
        }
    }
}

