/*
 * Decompiled with CFR 0.152.
 */
package zz.org.eclipse.jgit.diff;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import zz.org.eclipse.jgit.diff.RawText;
import zz.org.eclipse.jgit.errors.MissingObjectException;
import zz.org.eclipse.jgit.lib.ObjectLoader;
import zz.org.eclipse.jgit.lib.ObjectStream;

public class SimilarityIndex {
    public static final TableFullException TABLE_FULL_OUT_OF_MEMORY = new TableFullException();
    private static final int KEY_SHIFT = 32;
    private static final long MAX_COUNT = 0xFFFFFFFFL;
    private long hashedCnt;
    private int idSize;
    private int idGrowAt;
    private long[] idHash = new long[1 << this.idHashBits];
    private int idHashBits = 8;

    public static SimilarityIndex create(ObjectLoader obj) throws IOException, TableFullException {
        SimilarityIndex idx = new SimilarityIndex();
        idx.hash(obj);
        idx.sort();
        return idx;
    }

    SimilarityIndex() {
        this.idGrowAt = SimilarityIndex.growAt(this.idHashBits);
    }

    static boolean isBinary(ObjectLoader obj) throws IOException {
        if (obj.isLarge()) {
            Throwable throwable = null;
            Object var2_3 = null;
            try (ObjectStream in1 = obj.openStream();){
                return RawText.isBinary(in1);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        return RawText.isBinary(obj.getCachedBytes());
    }

    void hash(ObjectLoader obj) throws MissingObjectException, IOException, TableFullException {
        if (obj.isLarge()) {
            this.hashLargeObject(obj);
        } else {
            byte[] raw = obj.getCachedBytes();
            this.hash(raw, 0, raw.length);
        }
    }

    private void hashLargeObject(ObjectLoader obj) throws IOException, TableFullException {
        boolean text = !SimilarityIndex.isBinary(obj);
        Throwable throwable = null;
        Object var4_5 = null;
        try (ObjectStream in2 = obj.openStream();){
            this.hash(in2, in2.getSize(), text);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    void hash(byte[] raw, int ptr, int end) throws TableFullException {
        boolean text = !RawText.isBinary(raw);
        this.hashedCnt = 0L;
        while (ptr < end) {
            int hash = 5381;
            int blockHashedCnt = 0;
            int start = ptr;
            do {
                int c = raw[ptr++] & 0xFF;
                if (text && c == 13 && ptr < end && raw[ptr] == 10) continue;
                ++blockHashedCnt;
                if (c == 10) break;
                hash = (hash << 5) + hash + c;
            } while (ptr < end && ptr - start < 64);
            this.hashedCnt += (long)blockHashedCnt;
            this.add(hash, blockHashedCnt);
        }
    }

    void hash(InputStream in, long remaining, boolean text) throws IOException, TableFullException {
        byte[] buf = new byte[4096];
        int ptr = 0;
        int cnt = 0;
        while (0L < remaining) {
            int hash = 5381;
            int blockHashedCnt = 0;
            int n = 0;
            do {
                if (ptr == cnt) {
                    ptr = 0;
                    cnt = in.read(buf, 0, buf.length);
                    if (cnt <= 0) {
                        throw new EOFException();
                    }
                }
                ++n;
                int c = buf[ptr++] & 0xFF;
                if (text && c == 13 && ptr < cnt && buf[ptr] == 10) continue;
                ++blockHashedCnt;
                if (c == 10) break;
                hash = (hash << 5) + hash + c;
            } while (n < 64 && (long)n < remaining);
            this.hashedCnt += (long)blockHashedCnt;
            this.add(hash, blockHashedCnt);
            remaining -= (long)n;
        }
    }

    void sort() {
        Arrays.sort(this.idHash);
    }

    public int score(SimilarityIndex dst, int maxScore) {
        long max = Math.max(this.hashedCnt, dst.hashedCnt);
        if (max == 0L) {
            return maxScore;
        }
        return (int)(this.common(dst) * (long)maxScore / max);
    }

    long common(SimilarityIndex dst) {
        return SimilarityIndex.common(this, dst);
    }

    private static long common(SimilarityIndex src, SimilarityIndex dst) {
        int srcIdx = src.packedIndex(0);
        int dstIdx = dst.packedIndex(0);
        long[] srcHash = src.idHash;
        long[] dstHash = dst.idHash;
        return SimilarityIndex.common(srcHash, srcIdx, dstHash, dstIdx);
    }

    private static long common(long[] srcHash, int srcIdx, long[] dstHash, int dstIdx) {
        if (srcIdx == srcHash.length || dstIdx == dstHash.length) {
            return 0L;
        }
        long common = 0L;
        int srcKey = SimilarityIndex.keyOf(srcHash[srcIdx]);
        int dstKey = SimilarityIndex.keyOf(dstHash[dstIdx]);
        while (true) {
            if (srcKey == dstKey) {
                common += Math.min(SimilarityIndex.countOf(srcHash[srcIdx]), SimilarityIndex.countOf(dstHash[dstIdx]));
                if (++srcIdx == srcHash.length) break;
                srcKey = SimilarityIndex.keyOf(srcHash[srcIdx]);
                if (++dstIdx == dstHash.length) break;
                dstKey = SimilarityIndex.keyOf(dstHash[dstIdx]);
                continue;
            }
            if (srcKey < dstKey) {
                if (++srcIdx == srcHash.length) break;
                srcKey = SimilarityIndex.keyOf(srcHash[srcIdx]);
                continue;
            }
            if (++dstIdx == dstHash.length) break;
            dstKey = SimilarityIndex.keyOf(dstHash[dstIdx]);
        }
        return common;
    }

    int size() {
        return this.idSize;
    }

    int key(int idx) {
        return SimilarityIndex.keyOf(this.idHash[this.packedIndex(idx)]);
    }

    long count(int idx) {
        return SimilarityIndex.countOf(this.idHash[this.packedIndex(idx)]);
    }

    int findIndex(int key) {
        int i = 0;
        while (i < this.idSize) {
            if (this.key(i) == key) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private int packedIndex(int idx) {
        return this.idHash.length - this.idSize + idx;
    }

    void add(int key, int cnt) throws TableFullException {
        key = key * -1640562687 >>> 1;
        int j = this.slot(key);
        while (true) {
            long v;
            if ((v = this.idHash[j]) == 0L) {
                if (this.idGrowAt <= this.idSize) {
                    this.grow();
                    j = this.slot(key);
                    continue;
                }
                this.idHash[j] = SimilarityIndex.pair(key, cnt);
                ++this.idSize;
                return;
            }
            if (SimilarityIndex.keyOf(v) == key) {
                this.idHash[j] = SimilarityIndex.pair(key, SimilarityIndex.countOf(v) + (long)cnt);
                return;
            }
            if (++j < this.idHash.length) continue;
            j = 0;
        }
    }

    private static long pair(int key, long cnt) throws TableFullException {
        if (0xFFFFFFFFL < cnt) {
            throw new TableFullException();
        }
        return (long)key << 32 | cnt;
    }

    private int slot(int key) {
        return key >>> 31 - this.idHashBits;
    }

    private static int growAt(int idHashBits) {
        return (1 << idHashBits) * (idHashBits - 3) / idHashBits;
    }

    private void grow() throws TableFullException {
        if (this.idHashBits == 30) {
            throw new TableFullException();
        }
        long[] oldHash = this.idHash;
        int oldSize = this.idHash.length;
        ++this.idHashBits;
        this.idGrowAt = SimilarityIndex.growAt(this.idHashBits);
        try {
            this.idHash = new long[1 << this.idHashBits];
        }
        catch (OutOfMemoryError noMemory) {
            throw TABLE_FULL_OUT_OF_MEMORY;
        }
        int i = 0;
        while (i < oldSize) {
            long v = oldHash[i];
            if (v != 0L) {
                int j = this.slot(SimilarityIndex.keyOf(v));
                while (this.idHash[j] != 0L) {
                    if (++j < this.idHash.length) continue;
                    j = 0;
                }
                this.idHash[j] = v;
            }
            ++i;
        }
    }

    private static int keyOf(long v) {
        return (int)(v >>> 32);
    }

    private static long countOf(long v) {
        return v & 0xFFFFFFFFL;
    }

    public static class TableFullException
    extends Exception {
        private static final long serialVersionUID = 1L;
    }
}

