/*
 * Decompiled with CFR 0.152.
 */
package zz.org.cyclonedx.util.serializer;

import java.io.IOException;
import zz.com.fasterxml.jackson.core.JsonGenerator;
import zz.com.fasterxml.jackson.databind.SerializerProvider;
import zz.com.fasterxml.jackson.databind.ser.std.StdSerializer;
import zz.com.fasterxml.jackson.dataformat.xml.ser.ToXmlGenerator;
import zz.org.cyclonedx.model.formulation.common.EnvVariableChoice;
import zz.org.cyclonedx.model.formulation.common.OutputType;

public class OutputTypeSerializer
extends StdSerializer<OutputType> {
    private final boolean isXml;

    public OutputTypeSerializer(boolean isXml) {
        this((Class<OutputType>)null, isXml);
    }

    public OutputTypeSerializer(Class<OutputType> t, boolean isXml) {
        super(t);
        this.isXml = isXml;
    }

    @Override
    public void serialize(OutputType value, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        if (this.isXml && jsonGenerator instanceof ToXmlGenerator) {
            ToXmlGenerator xmlGenerator = (ToXmlGenerator)jsonGenerator;
            xmlGenerator.writeStartObject();
            xmlGenerator.writeFieldName("input");
            this.createOutputChoice(value, xmlGenerator);
            xmlGenerator.writeEndObject();
        } else {
            this.createOutputChoice(value, jsonGenerator);
        }
    }

    private void createOutputChoice(OutputType output, JsonGenerator jsonGenerator) throws IOException {
        jsonGenerator.writeStartObject();
        if (output.getResource() != null) {
            jsonGenerator.writeFieldName("resource");
            jsonGenerator.writeObject(output.getResource());
        } else if (output.getEnvironmentVars() != null && !output.getEnvironmentVars().isEmpty()) {
            jsonGenerator.writeArrayFieldStart("environmentVars");
            for (EnvVariableChoice envVarChoice : output.getEnvironmentVars()) {
                if (envVarChoice.getEnvironmentVar() != null) {
                    jsonGenerator.writeStartObject();
                    jsonGenerator.writeObjectField("environmentVar", envVarChoice.getEnvironmentVar());
                    jsonGenerator.writeEndObject();
                    continue;
                }
                if (envVarChoice.getValue() == null) continue;
                jsonGenerator.writeStartObject();
                jsonGenerator.writeObjectField("value", envVarChoice.getValue());
                jsonGenerator.writeEndObject();
            }
            jsonGenerator.writeEndArray();
        } else if (output.getData() != null) {
            jsonGenerator.writeFieldName("data");
            jsonGenerator.writeObject(output.getData());
        }
        if (output.getType() != null) {
            jsonGenerator.writeFieldName("type");
            jsonGenerator.writeObject((Object)output.getType());
        }
        if (output.getSource() != null) {
            jsonGenerator.writeFieldName("source");
            jsonGenerator.writeObject(output.getSource());
        }
        if (output.getTarget() != null) {
            jsonGenerator.writeFieldName("target");
            jsonGenerator.writeObject(output.getTarget());
        }
        if (output.getProperties() != null) {
            jsonGenerator.writeFieldName("properties");
            jsonGenerator.writeObject(output.getProperties());
        }
        jsonGenerator.writeEndObject();
    }

    @Override
    public Class<OutputType> handledType() {
        return OutputType.class;
    }
}

