/*
 * Decompiled with CFR 0.152.
 */
package zz.org.cyclonedx.util.serializer;

import java.io.IOException;
import java.util.List;
import zz.com.fasterxml.jackson.core.JsonGenerator;
import zz.com.fasterxml.jackson.databind.SerializerProvider;
import zz.com.fasterxml.jackson.databind.ser.std.StdSerializer;
import zz.com.fasterxml.jackson.dataformat.xml.ser.ToXmlGenerator;
import zz.org.cyclonedx.CycloneDxSchema;
import zz.org.cyclonedx.model.Metadata;
import zz.org.cyclonedx.model.Property;
import zz.org.cyclonedx.model.metadata.ToolInformation;
import zz.org.cyclonedx.util.serializer.CustomDateSerializer;
import zz.org.cyclonedx.util.serializer.LicenseChoiceSerializer;
import zz.org.cyclonedx.util.serializer.LifecycleSerializer;

public class MetadataSerializer
extends StdSerializer<Metadata> {
    private final boolean isXml;
    private final CycloneDxSchema.Version version;

    public MetadataSerializer(boolean isXml, CycloneDxSchema.Version version) {
        this(null, isXml, version);
    }

    public MetadataSerializer(Class<Metadata> t, boolean isXml, CycloneDxSchema.Version version) {
        super(t);
        this.isXml = isXml;
        this.version = version;
    }

    @Override
    public void serialize(Metadata output, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        if (this.isXml && jsonGenerator instanceof ToXmlGenerator) {
            ToXmlGenerator xmlGenerator = (ToXmlGenerator)jsonGenerator;
            this.createMetadataInfo(output, xmlGenerator, serializerProvider);
        } else {
            this.createMetadataInfo(output, jsonGenerator, serializerProvider);
        }
    }

    private void createMetadataInfo(Metadata metadata, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        ToXmlGenerator xmlGenerator;
        jsonGenerator.writeStartObject();
        if (metadata.getTimestamp() != null) {
            jsonGenerator.writeFieldName("timestamp");
            new CustomDateSerializer().serialize(metadata.getTimestamp(), jsonGenerator, serializerProvider);
        }
        if (metadata.getLifecycles() != null) {
            jsonGenerator.writeFieldName("lifecycles");
            new LifecycleSerializer(this.isXml).serialize(metadata.getLifecycles(), jsonGenerator, serializerProvider);
        }
        this.parseTools(metadata, jsonGenerator);
        if (metadata.getAuthors() != null) {
            if (this.isXml) {
                xmlGenerator = (ToXmlGenerator)jsonGenerator;
                this.writeArrayFieldXML(metadata.getAuthors(), xmlGenerator, "author");
            } else {
                jsonGenerator.writeObjectField("authors", metadata.getAuthors());
            }
        }
        if (metadata.getComponent() != null) {
            jsonGenerator.writeObjectField("component", metadata.getComponent());
        }
        if (metadata.getManufacture() != null) {
            jsonGenerator.writeObjectField("manufacture", metadata.getManufacture());
        }
        if (metadata.getSupplier() != null) {
            jsonGenerator.writeObjectField("supplier", metadata.getSupplier());
        }
        if (metadata.getLicenseChoice() != null) {
            jsonGenerator.writeFieldName("licenses");
            new LicenseChoiceSerializer().serialize(metadata.getLicenseChoice(), jsonGenerator, serializerProvider);
        }
        if (metadata.getProperties() != null) {
            if (this.isXml) {
                xmlGenerator = (ToXmlGenerator)jsonGenerator;
                xmlGenerator.writeFieldName("properties");
                xmlGenerator.writeStartObject();
                for (Property property : metadata.getProperties()) {
                    xmlGenerator.writeObjectField("property", property);
                }
                xmlGenerator.writeEndObject();
            } else {
                jsonGenerator.writeObjectField("properties", metadata.getProperties());
            }
        }
        jsonGenerator.writeEndObject();
    }

    private void parseTools(Metadata metadata, JsonGenerator jsonGenerator) throws IOException {
        ToolInformation choice;
        if (metadata.getTools() != null) {
            if (this.isXml && jsonGenerator instanceof ToXmlGenerator) {
                this.writeArrayFieldXML(metadata.getTools(), (ToXmlGenerator)jsonGenerator, "tool");
            } else {
                this.writeArrayFieldJSON(jsonGenerator, "tools", metadata.getTools());
            }
        } else if (this.version.getVersion() >= CycloneDxSchema.Version.VERSION_15.getVersion() && (choice = metadata.getToolChoice()) != null) {
            jsonGenerator.writeFieldName("tools");
            jsonGenerator.writeStartObject();
            if (this.isXml && jsonGenerator instanceof ToXmlGenerator) {
                if (choice.getComponents() != null) {
                    this.writeArrayFieldXML(choice.getComponents(), (ToXmlGenerator)jsonGenerator, "component");
                }
                if (choice.getServices() != null) {
                    this.writeArrayFieldXML(choice.getServices(), (ToXmlGenerator)jsonGenerator, "service");
                }
            } else {
                if (choice.getComponents() != null) {
                    this.writeArrayFieldJSON(jsonGenerator, "components", choice.getComponents());
                }
                if (choice.getServices() != null) {
                    this.writeArrayFieldJSON(jsonGenerator, "services", choice.getServices());
                }
            }
            jsonGenerator.writeEndObject();
        }
    }

    private <T> void writeArrayFieldJSON(JsonGenerator jsonGenerator, String fieldName, List<T> items) throws IOException {
        if (items != null) {
            jsonGenerator.writeArrayFieldStart(fieldName);
            for (T item : items) {
                jsonGenerator.writeObject(item);
            }
            jsonGenerator.writeEndArray();
        }
    }

    private <T> void writeArrayFieldXML(List<T> items, ToXmlGenerator xmlGenerator, String fieldName) throws IOException {
        if (items != null) {
            xmlGenerator.writeFieldName(fieldName + "s");
            xmlGenerator.writeStartArray();
            for (T item : items) {
                xmlGenerator.writeStartObject();
                xmlGenerator.writeObjectField(fieldName, item);
                xmlGenerator.writeEndObject();
            }
            xmlGenerator.writeEndArray();
        }
    }

    @Override
    public Class<Metadata> handledType() {
        return Metadata.class;
    }
}

