/*
 * Decompiled with CFR 0.152.
 */
package zz.org.cyclonedx.util.serializer;

import java.io.IOException;
import java.util.List;
import zz.com.fasterxml.jackson.core.JsonGenerator;
import zz.com.fasterxml.jackson.databind.SerializerProvider;
import zz.com.fasterxml.jackson.databind.ser.std.StdSerializer;
import zz.com.fasterxml.jackson.dataformat.xml.ser.ToXmlGenerator;
import zz.org.cyclonedx.model.LifecycleChoice;
import zz.org.cyclonedx.model.Lifecycles;

public class LifecycleSerializer
extends StdSerializer<Lifecycles> {
    private final boolean isXml;

    public LifecycleSerializer(boolean isXml) {
        this((Class<Lifecycles>)null, isXml);
    }

    public LifecycleSerializer(Class<Lifecycles> t, boolean isXml) {
        super(t);
        this.isXml = isXml;
    }

    @Override
    public void serialize(Lifecycles lifecycles, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        if (this.isXml && jsonGenerator instanceof ToXmlGenerator) {
            ToXmlGenerator xmlGenerator = (ToXmlGenerator)jsonGenerator;
            xmlGenerator.writeStartObject();
            xmlGenerator.writeFieldName("lifecycle");
            xmlGenerator.writeStartArray();
            this.createLifecycleChoice(lifecycles, xmlGenerator);
            xmlGenerator.writeEndArray();
            xmlGenerator.writeEndObject();
        } else {
            jsonGenerator.writeStartArray();
            this.createLifecycleChoice(lifecycles, jsonGenerator);
            jsonGenerator.writeEndArray();
        }
    }

    private void createLifecycleChoice(Lifecycles lifecycles, JsonGenerator jsonGenerator) throws IOException {
        List<LifecycleChoice> lifecycleChoices = lifecycles.getLifecycleChoice();
        for (LifecycleChoice choice : lifecycleChoices) {
            jsonGenerator.writeStartObject();
            if (choice.getPhase() != null) {
                jsonGenerator.writeStringField("phase", choice.getPhase().getPhaseName());
            } else {
                jsonGenerator.writeStringField("name", choice.getName());
                jsonGenerator.writeStringField("description", choice.getDescription());
            }
            jsonGenerator.writeEndObject();
        }
    }

    @Override
    public Class<Lifecycles> handledType() {
        return Lifecycles.class;
    }
}

