/*
 * Decompiled with CFR 0.152.
 */
package zz.org.cyclonedx.util.serializer;

import java.io.IOException;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import zz.com.fasterxml.jackson.core.JsonGenerator;
import zz.com.fasterxml.jackson.databind.SerializerProvider;
import zz.com.fasterxml.jackson.databind.ser.std.StdSerializer;
import zz.com.fasterxml.jackson.dataformat.xml.ser.ToXmlGenerator;
import zz.org.cyclonedx.model.Attribute;
import zz.org.cyclonedx.model.ExtensibleType;

public class ExtensibleTypesSerializer
extends StdSerializer<List<ExtensibleType>> {
    private final String XMLNS = "xmlns";

    public ExtensibleTypesSerializer() {
        this((Class<List<ExtensibleType>>)null);
    }

    public ExtensibleTypesSerializer(Class<List<ExtensibleType>> t) {
        super(t);
    }

    @Override
    public void serialize(List<ExtensibleType> extensibleTypes, JsonGenerator generator, SerializerProvider provider) throws IOException {
        ToXmlGenerator toXmlGenerator = (ToXmlGenerator)generator;
        XMLStreamWriter staxWriter = toXmlGenerator.getStaxWriter();
        try {
            if (extensibleTypes != null && !extensibleTypes.isEmpty()) {
                for (ExtensibleType ext : extensibleTypes) {
                    if (ext.getAttributes() != null && !ext.getAttributes().isEmpty()) {
                        Attribute xmlNS = ext.getAttributes().stream().filter(a -> a.getKey().contains("xmlns")).findAny().orElse(null);
                        if (xmlNS != null) {
                            staxWriter.writeStartElement(ext.getNamespace(), ext.getName(), xmlNS.getValue());
                            for (Attribute attr : ext.getAttributes()) {
                                staxWriter.writeAttribute(attr.getKey(), attr.getValue());
                            }
                        }
                    } else {
                        staxWriter.writeStartElement(ext.getNamespace(), ext.getName(), "http://www.w3.org/1999/xhtml");
                    }
                    if (ext.getExtensibleTypes() != null && !ext.getExtensibleTypes().isEmpty()) {
                        this.serialize(ext.getExtensibleTypes(), generator, provider);
                    }
                    if (ext.getValue() != null) {
                        staxWriter.writeCharacters(ext.getValue());
                    }
                    staxWriter.writeEndElement();
                }
            }
        }
        catch (XMLStreamException e) {
            throw new IOException(e);
        }
    }
}

